unit graf_fx;

interface

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////////////////////}

uses crt;

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////////////////////}

type wielka_tablica = array[0..63999] of byte;

type obraz = record
              szerokosc : word;
              wysokosc : word;
              wsk_obrazu : ^wielka_tablica;
              rozmiar : word;
             end;

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;

type wzorzec_koloru = record
                       czerwony : byte;
                       zielony : byte;
                       niebieski : byte;
                      end;

type prostokat = record
                  x : integer;
                  y : integer;
                  szerokosc : integer;
                  wysokosc : integer;
                 end;

type wzorzec_znaku = array[0..7] of byte;

type paleta_kolorow = array[0..255] of wzorzec_koloru;

type naglowek_WAV = record
                    tab_RIFF : array[0..3] of char;
                    rozmiar_pliku_bez_8 : longint;
                    tab_WAVE : array[0..3] of char;
                    tab_fmt : array[0..3] of char;
                    liczba_bajtow_do_data : longint;
                    format_danych : word;
                    liczba_kanalow : word;
                    czestotliwosc : longint;
                    liczba_bajtow_na_sekunde : longint;
                    liczba_bajtow_na_cykl : word;
                    liczba_bitow_na_probke : word;
                    tab_data : array[0..3] of char;
                    rozmiar_danych_dzwiekowych : longint;
                    end;

type fala_dzwiekowa = record
                       naglowek : naglowek_WAV;
                       wsk_bufora : pointer;
                      end;

type wierzcholek = record
                   x, y, z : real;
                   u, v : byte;
                   kolor : byte;
                   end;

type trojkat = array[0..2] of wierzcholek;

type wskaznik_na_w = ^wierzcholek;

type wskaznik_na_t = ^trojkat;

{// D E F I N I C J E    Z M I E N N Y C H
{///////////////////////////////////////////////////////}

const g_tab_znakow : array[0..70] of wzorzec_znaku =
      (
       ($00, $00, $00, $00, $00, $08, $00, $00),  {0}{'.'}
       ($18, $24, $24, $24, $24, $18, $00, $00),  {1}{'0'}
       ($18, $28, $08, $08, $08, $3C, $00, $00),  {2}{'1'}
       ($38, $44, $08, $10, $20, $7C, $00, $00),  {3}{'2'}
       ($38, $44, $04, $18, $44, $38, $00, $00),  {4}{'3'}
       ($20, $20, $24, $3E, $04, $04, $00, $00),  {5}{'4'}
       ($3E, $20, $3C, $02, $02, $3C, $00, $00),  {6}{'5'}
       ($1C, $20, $38, $24, $24, $18, $00, $00),  {7}{'6'}
       ($3C, $44, $08, $10, $10, $10, $00, $00),  {8}{'7'}
       ($18, $24, $18, $24, $24, $18, $00, $00),  {9}{'8'}
       ($18, $24, $1C, $04, $04, $18, $00, $00),  {10}{'9'}
       ($18, $24, $24, $7E, $42, $42, $00, $00),  {11}{'A'}
       ($7C, $22, $3C, $22, $22, $7C, $00, $00),  {12}{'B'}
       ($3C, $42, $40, $40, $42, $3C, $00, $00),  {13}{'C'}
       ($7C, $22, $22, $22, $22, $7C, $00, $00),  {14}{'D'}
       ($7E, $22, $38, $20, $22, $7E, $00, $00),  {15}{'E'}
       ($7E, $22, $38, $20, $20, $70, $00, $00),  {16}{'F'}
       ($1C, $22, $20, $26, $22, $1C, $00, $00),  {17}{'G'}
       ($44, $44, $7C, $44, $44, $44, $00, $00),  {18}{'H'}
       ($38, $10, $10, $10, $10, $38, $00, $00),  {19}{'I'}
       ($70, $10, $10, $90, $90, $70, $00, $00),  {20}{'J'}
       ($64, $28, $30, $28, $24, $64, $00, $00),  {21}{'K'}
       ($38, $10, $10, $10, $12, $1E, $00, $00),  {22}{'L'}
       ($22, $36, $2A, $22, $22, $22, $00, $00),  {23}{'M'}
       ($22, $32, $2A, $26, $22, $22, $00, $00),  {24}{'N'}
       ($38, $44, $44, $44, $44, $38, $00, $00),  {25}{'O'}
       ($7C, $22, $3C, $20, $20, $70, $00, $00),  {26}{'P'}
       ($38, $44, $44, $44, $4C, $38, $08, $04),  {27}{'Q'}
       ($7C, $22, $3C, $22, $22, $62, $00, $00),  {28}{'R'}
       ($18, $24, $10, $08, $24, $18, $00, $00),  {29}{'S'}
       ($7F, $49, $08, $08, $08, $1C, $00, $00),  {30}{'T'}
       ($22, $22, $22, $22, $22, $1C, $00, $00),  {31}{'U'}
       ($22, $22, $22, $22, $14, $08, $00, $00),  {32}{'V'}
       ($22, $22, $22, $2A, $36, $22, $00, $00),  {33}{'W'}
       ($22, $14, $08, $14, $22, $22, $00, $00),  {34}{'X'}
       ($22, $22, $14, $08, $08, $1C, $00, $00),  {35}{'Y'}
       ($3E, $22, $04, $08, $12, $3E, $00, $00),  {36}{'Z'}
       ($00, $00, $38, $44, $44, $3E, $00, $00),  {37}{'a'}
       ($20, $20, $3C, $22, $22, $3C, $00, $00),  {38}{'b'}
       ($00, $00, $1C, $20, $20, $1C, $00, $00),  {39}{'c'}
       ($02, $02, $1E, $22, $22, $1E, $00, $00),  {40}{'d'}
       ($00, $1C, $22, $3E, $20, $1C, $00, $00),  {41}{'e'}
       ($18, $24, $20, $70, $20, $20, $00, $00),  {42}{'f'}
       ($00, $00, $1C, $22, $22, $1E, $02, $1C),  {43}{'g'}
       ($20, $20, $3C, $22, $22, $22, $00, $00),  {44}{'h'}
       ($00, $10, $00, $10, $10, $10, $00, $00),  {45}{'i'}
       ($00, $10, $00, $10, $10, $10, $10, $70),  {46}{'j'}
       ($20, $20, $24, $38, $24, $24, $00, $00),  {47}{'k'}
       ($20, $20, $20, $20, $20, $38, $00, $00),  {48}{'l'}
       ($00, $00, $63, $55, $49, $41, $00, $00),  {49}{'m'}
       ($00, $00, $2E, $11, $11, $11, $00, $00),  {50}{'n'}
       ($00, $00, $1C, $22, $22, $1C, $00, $00),  {51}{'o'}
       ($00, $00, $3C, $22, $22, $3C, $20, $20),  {52}{'p'}
       ($00, $00, $1E, $22, $22, $1E, $02, $02),  {53}{'q'}
       ($00, $00, $2C, $12, $10, $10, $00, $00),  {54}{'r'}
       ($00, $3C, $22, $18, $44, $38, $00, $00),  {55}{'s'}
       ($10, $10, $38, $10, $10, $10, $00, $00),  {56}{'t'}
       ($00, $00, $24, $24, $24, $18, $00, $00),  {57}{'u'}
       ($00, $00, $14, $14, $14, $08, $00, $00),  {58}{'v'}
       ($00, $00, $41, $49, $55, $63, $00, $00),  {59}{'w'}
       ($00, $00, $24, $18, $18, $24, $00, $00),  {60}{'x'}
       ($00, $00, $24, $24, $24, $3C, $04, $3C),  {61}{'y'}
       ($00, $00, $3C, $08, $10, $3C, $00, $00),  {62}{'z'}
       ($00, $00, $00, $3C, $00, $00, $00, $00),  {63}{'-'}
       ($00, $00, $10, $38, $10, $00, $00, $00),  {64}{'+'}
       ($00, $00, $00, $00, $00, $10, $10, $20),  {65}{','}
       ($00, $02, $04, $08, $10, $20, $00, $00),  {66}{'/'}
       ($00, $14, $08, $14, $00, $00, $00, $00),  {67}{'*'}
       ($00, $00, $08, $00, $00, $08, $00, $00),  {68}{':'}
       ($00, $00, $3C, $00, $3C, $00, $00, $00),  {69}{'='}
       ($00, $00, $00, $00, $00, $7E, $00, $00)   {70}{'_'}
      );

odleglosc_do_PR : real = 128;         {czyli 2 do potegi 7}
p_obcinania : real = 0.01;
srodek_e_x : byte = 159;
srodek_e_y : byte = 99;
widocznosc_t : byte = 1;

var
port_2x6 : word;
port_2xA : word;
port_2xC : word;
port_2xE : word;
tab_sin : array[0..359] of real;
tab_cos : array[0..359] of real;

{// N A G L O W K I  P R O C E D U R  I  F U N K C J I}
{///////////////////////////////////////////////////////}

procedure g_ustaw_tryb_vga(tryb : byte);
procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
procedure g_zamaluj_ekran_13h(kolor : byte);
procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
procedure g_laduj_palete_BMP( szciezka : string);
procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
procedure g_wyswietl_obraz_13h(wsk_buforu : pointer; zrodlo, cel : prostokat; rys : obraz);
procedure g_zwolnij_pam( rys : obraz);
procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                 rys : obraz; czy_p_kolor : boolean; p_kolor : byte);
procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                   rys : obraz; czy_p_kolor : boolean; p_kolor : byte);
procedure g_pobierz_skan_kod(var kod_scan : byte);
procedure g_powtarzanie_klawiszy( liczba, opoznienie : byte);
procedure g_sys_klawiatura( stan : boolean);
procedure g_pokaz_kursor( status : boolean);
procedure g_pobierz_status_myszy(var lewy, srodkowy, prawy : boolean;
                               var poz_x, poz_y : word);
procedure g_wyswietl_tekst_13h( wsk_bufora : pointer; x, y : word;
                                tekst : string; kolor : byte);
procedure g_ustaw_wzorzec_koloru(nr_wzorca : byte; c, z, n : byte);
procedure g_pobierz_pam_dla_drugiego_bufora(var wsk_bufora : pointer);
procedure g_zwolnij_pam_bufora(var wsk_bufora : pointer);
procedure g_kopiuj_bufor( buf_docelowy, buf_zrodlowy : pointer);
procedure g_czekaj_na_powrot_pionowy;
procedure g_wypelnij_bufor(adres : pointer; kolor : byte);
procedure g_pobierz_palete_VGA(var paleta : paleta_kolorow);
procedure g_pobierz_wzorzec_koloru(nr_wzorca : byte; var wzorzec : wzorzec_koloru);
procedure g_wygas_ekran(przerwa : byte);
procedure g_rozjasnij_ekran(var paleta_k : paleta_kolorow; przerwa : byte);
procedure g_topnienie_ekranu(kolor : byte);
procedure g_zalej_ekran( kolor, przerwa : byte);
function g_zresetuj_SB( baza : byte):boolean;
procedure g_zapisz_do_SB(data : byte);
procedure g_odczytaj_z_SB(var data : byte);
procedure g_wlacz_glosniki;
procedure g_wylacz_glosniki;
procedure g_przestan_odtwarzac;
procedure g_laduj_WAV(var data : fala_dzwiekowa; szciezka : string);
procedure g_zwolnij_pam_w( data : fala_dzwiekowa);
procedure g_odegraj_WAV( fala : fala_dzwiekowa; czestotliwosc: word);
procedure g_inicjuj_tab_sin_i_cos;
procedure g_oblicz_dlugosc_wektora(var a, b : wierzcholek;
                                   var dlugosc : real);
procedure g_dodaj_wektory(var a, b, c : wierzcholek);
procedure g_odejmij_wektory(var a, b, c : wierzcholek);
procedure g_pomnuz_wektor_przez_liczbe(var a : wierzcholek;
                                       liczba : real;
                                       var b : wierzcholek);
procedure g_oblicz_iloczyn_skalarny_wektorow(var a, b : wierzcholek;
                                             var wynik : real);
procedure g_oblicz_wektorowe_mnozenie_wektorow(var a, b, c : wierzcholek);
procedure g_obroc_wierzcholki_wokol_osi_x(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
procedure g_obroc_wierzcholki_wokol_osi_y(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
procedure g_obroc_wierzcholki_wokol_osi_z(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
procedure g_obroc_trojkaty_wokol_osi_x(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
procedure g_obroc_trojkaty_wokol_osi_y(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
procedure g_obroc_trojkaty_wokol_osi_z(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
procedure g_przesun_wierzcholki(tab : wskaznik_na_w;
                                dx,dy,dz : real;
                                ile : word);
procedure g_przesun_trojkaty(tab : wskaznik_na_t;
                             dx,dy,dz : real;
                             ile : word);
procedure g_skaluj_wierzcholki(tab : wskaznik_na_w; skala : real; ile : word);
procedure g_skaluj_trojkaty(tab : wskaznik_na_t; skala : real; ile : word);
procedure g_rzutuj_wierzcholki(tab : wskaznik_na_w; ile : word);
procedure g_rzutuj_trojkaty( tab : wskaznik_na_t; ile : word);
procedure g_rysuj_piksel_w_buforze(buf : pointer; x,y : word; kolor:byte);
procedure g_przygotuj_trojkaty_do_rysowania_m_punktowa(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_w;
                                        ile : word;
                                        var liczba_widocznych  : word);
procedure g_wyswietl_trojkaty_m_punktowa(buf : pointer;
                                         zrodlo : wskaznik_na_w;
                                         ile : word;
                                         kolor : byte);
function g_pobierz_znak(liczba : real):integer;
procedure g_rysuj_linie_w_buforze(bufor : pointer;
                                  x1, y1, x2, y2 : longint;
                                  kolor : byte);
function g_przytnij_linie(w1,w2 : wierzcholek;
                          var w3, w4 : wierzcholek ):boolean;
procedure g_przygotuj_trojkaty_do_rysowania_m_siatkowa(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_w;
                                        ile : word;
                                        var liczba_widocznych  : word);
procedure g_wyswietl_trojkaty_m_siatkowa(buf : pointer;
                                         zrodlo : wskaznik_na_w;
                                         ile : word;
                                         kolor : byte);
procedure g_rysuj_pozioma_linia_w_buforze(buf : pointer;
                                          x1, x2, y : word;
                                          kolor : byte);
procedure g_przygotuj_trojkaty_do_rysowania_m_wypelnione(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word);
procedure g_kontrola_linii_m_wypelnione(buf : pointer;
                                        x1, x2, y : longint;
                                        kolor : byte);
procedure g_wyswietl_trojkaty_m_wypelnione(buf : pointer;
                                           zrodlo : wskaznik_na_t;
                                           ile : word;
                                           kolor : byte;
                                           ktory_kolor : boolean);
procedure g_normalizuj_wektor(wektor : wierzcholek;
                              var wynik : wierzcholek);
procedure g_przygotuj_trojkaty_do_rysowania_m_cieniowanie_p(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word;
                                        swiatlo : wierzcholek;
                                        numer_pierwszego : byte;
                                        ile_kolorow : byte);
procedure g_przygotuj_trojkaty_do_rysowania_m_tekstura(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word);
procedure g_kontrola_linii_m_tekstura(buf : pointer;
                                      x1, x2, y : longint;
                                      u1, v1, u2, v2 : byte;
                                      tekstura : obraz;
                                      ile_przesunac : byte);
procedure g_wyswietl_trojkaty_m_tekstura(buf : pointer;
                                         zrodlo : wskaznik_na_t;
                                         ile : word;
                                         tekstura : obraz);
procedure g_kontrola_linii_m_tekstura_kp(buf : pointer;
                                      x1, x2, y : longint;
                                      u1, v1, u2, v2 : single;
                                      tekstura : obraz;
                                      ile_przesunac : byte;
                                      z1, z2 : single
                                      );
procedure g_wyswietl_trojkaty_m_tekstura_kp(buf : pointer;
                                         zrodlo : wskaznik_na_t;
                                         ile : word;
                                         tekstura : obraz
                                         );

implementation


procedure g_ustaw_tryb_vga(tryb : byte);
begin
asm

mov ah, 00h  {zaladuj 00h do AH - numer funkcji przerwania 10h}
mov al, tryb {zaladuj tryb do AL - numer trybu pracy karty graficznej}
int 10h      {wywolaj przerwanie 10h}

end;
end; {koniec procedury g_ustaw_tryb_vga}

{--------------}

procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
begin
asm

mov ax, y                {zaladuj y do AX}
mov di, ax               {zaladuj AX do DI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6                {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov ax, 0a000h           {zaladuj A000 do AX}
mov es, ax               {zaladuj AX do ES}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz pod adres ES:DI warto rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_13h}

{--------------}

procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
begin
asm
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax,y          {zaladuj y do AX}
mov di,ax         {zaladuj AX do DI}
shl ax,8          {przesun bity rejestru AX o 8 pozycji w lewo}
shl di,6          {przesun bity rejestru DI o 6 pozycji w lewo}
add di,ax         {dodaj AX do DI}
add di,x1         {dodaj x do DI}
mov ax,0a000h     {zaladuj A000 do AX}
mov es,ax         {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;
end; {koniec procedury g_rysuj_pozioma_linia_13h}

{--------------}

procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
begin
asm

mov cx, y2        {zaladuj y2 do CX}
sub cx, y1        {odejmij y1 od CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y1        {zaladuj 1 do AX}
mov di, ax        {zaladuj AX do DI}
shl ax, 8         {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6         {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax        {dodaj AX do DI}
add di, x         {dodaj x do DI}
mov ax, 0a000h    {zaladuj A000 do AX}
mov es, ax        {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}

@rysuj_linie:     {definicja etykiety}
mov es:[di], al   {zapisz AL do komorki pamieci o adresie ES:DI}
add di, 320       {dodaj 320 do DI}
loop @rysuj_linie {zmiejsz CX o 1, jezeli rozny od 0 skocz do etykiety rysuj_linie}

end;
end; {koniec procedury g_rysuj_pionowa_linia_13h}

{--------------}

procedure g_zamaluj_ekran_13h(kolor : byte);
begin
asm

mov ax, 0A000h   {zaladuj A000h do AX}
mov es, ax       {zaladuj AX do ES}
mov di, 0        {zaladuj 0 do DI}
mov cx, 32000    {zaladuj 32000 do CX}
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_zamaluj_ekran_13h}

{--------------}

procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
var
plik : file;
naglowek : naglowek_pliku_BMP;
licznik, wynik : word;
licznik_odczytu : word;
begin

{Skojarzenie zbiory ze zmienna plikowa i otworzenie go}
assign(plik, szciezka);
reset(plik, 1);

{odczyt naglowka bitmapy}
licznik := sizeof(naglowek_pliku_BMP);
blockread(plik, naglowek, licznik, wynik);

{Sprawdzenie czy rozmiary obrazu sa zgodne z rozdzielczoscia ekranu }
if((naglowek.szerokosc_obrazu > 320) or
   (naglowek.wysokosc_obrazu > 200)) then
   begin
   close(plik);   {zamkniecie pliku}
   exit;          {opuszczenie procedury}
   end;  {koniec if then}

{przeskakujemy palete kolorow}
seek(plik,1078);

{zapisanie rozmiarow obrazu i oblicznie rozmiaru bloku pamieci
 potrzebnego do przechowywania obrazu}
z_obraz.szerokosc := naglowek.szerokosc_obrazu;
z_obraz.wysokosc := naglowek.wysokosc_obrazu;
z_obraz.rozmiar := naglowek.szerokosc_obrazu * naglowek.wysokosc_obrazu;

{Sparwdzamy czy system posiada dosc wolen pamieci do przechowywania
 ladowanego obrazu bitmapy, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < z_obraz.rozmiar) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla obrazu}
getmem(z_obraz.wsk_obrazu, z_obraz.rozmiar);

{zaladowanie obrazu - obraz podczas odczytu zostaje odwrucony w pionie}
licznik := naglowek.szerokosc_obrazu;
for licznik_odczytu := 0 to naglowek.wysokosc_obrazu - 1 do
begin
blockread(plik, z_obraz.wsk_obrazu^[(naglowek.wysokosc_obrazu - 1 - licznik_odczytu) * z_obraz.szerokosc], licznik, wynik);
end; {koniec petli for}

{zamkniecie pliku}
close(plik);

end; {koniec procedury g_laduj_BMP_13h}

{--------------}

procedure g_laduj_palete_BMP( szciezka : string);
var
plik : file;
paleta_k : array[0..255] of wzorzec_koloru_BMP;
licznik, wynik : word;
begin

{skojarzenie zmiennej plikowej plik ze zbiorem danych okreslonym
 przez parametr szciezka}
assign(plik, szciezka);

{otwarcie pliku}
reset(plik, 1);

{przesowa wskaznik pozycji pliku na pierwszy bajt palety kolorow}
seek(plik, sizeof(naglowek_pliku_BMP));

{ustalmy liczbe odczytywanych bajtow na rowna rozmiarowi zmiennej pleta_k}
licznik := sizeof(paleta_k);

{odczytanie palety kolorow}
blockread(plik, paleta_k,licznik, wynik);

{zapis palety kolorow do karty vga zaczynamy od pierwszego wzorca koloru}
port[$3c8] := 0;

{petla wysylajaca do portow karty graficznej palete kolorow}
for licznik :=  0 to 255 do
begin
port[$3c9] := paleta_k[licznik].czerwony shr 2;
port[$3c9] := paleta_k[licznik].zielony shr 2;
port[$3c9] := paleta_k[licznik].niebieski shr 2;
end; {koniec petli for}

{zamknij plik}
close(plik);

end; {koniec procedury g_laduj_palete_BMP}

{--------------}

procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
begin

p.x := x;
p.y := y;
p.szerokosc := s;
p.wysokosc := w;

end; {koniec procedury g_wypelnij_p}

{--------------}

procedure g_wyswietl_obraz_13h(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje z lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec procedury g_wyswietl_obraz_13h}

{--------------}

procedure g_zwolnij_pam( rys : obraz);
begin

freemem(rys.wsk_obrazu, rys.rozmiar);

end; {koniec procedury g_zwolnij_pam}

{--------------}

procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje za lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}

les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
mov ah, p_kolor           {zaladuj p_kolor do AH}

@petla:                   {definicja etykiety petla }
mov al, byte ptr ds:[si]  {zaladuj do AL bajt z pod adresu DS:SI}
cmp al, ah                {porowanaj AL z AH}
jz @przezroczysty         {jezeli AL jest rowne AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], al  {zapisz pod adres ES:DI wartosc rejestru AL}
@przezroczysty:           {definicja etykiety przezroczysty}
inc di                    {zwieksz DI o 1}
inc si                    {zwieksz SI o 1}
loop @petla               {zmiejsz CX i skocz do etykiety petla}

pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}
end;

end; {koniec procedury g_wyswietl_obraz_13h_k}

{--------------}

procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y,licznik_x : word;
stosunek_x, stosunek_y : real;
start_zrodlo : real;
start_bufor : word;
z_stosunek_y : real;
przeskok_zrodlo : word;
przeskok_bufor : word;
piksel : byte;
begin
z_stosunek_y := 0;

{zmiejszenie docelowego prostokata obrazu do wymiarow ekranu}
if ((cel.x < 0) or (cel.x > 319)) then exit;
if ((cel.y < 0) or (cel.y > 199)) then exit;

if ((cel.x + cel.szerokosc > 319)) then cel.szerokosc := 320 - cel.x;
if ((cel.y + cel.wysokosc > 199)) then cel.wysokosc := 200 - cel.y;

{obliczenie stosunkow rozdzielczosci zrodlowego prostokata do rozdzielczosci
 prostokata docelowego}
stosunek_x := zrodlo.szerokosc / cel.szerokosc;
stosunek_y := zrodlo.wysokosc / cel.wysokosc;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + (zrodlo.y * rys.szerokosc);

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego w buforze ekranu}
start_bufor := cel.x + (cel.y * 320);

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := 0;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu bez
 uwzgledniania przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:DI}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

{przesowamy sie w prawo rysujac kolejne piksele}
start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin

{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu z
 uwzglednieniem przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
cmp p_kolor, ah           {porownaj p_kolor z AH}
jz @przezroczysty         {jezeli p_kolor = AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:SI}
@przezroczysty:           {definicja etykiety przezroczysty}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec bloku else}

end; {koniec procedury g_wyswietl_obraz_13h_k_s}

{--------------}

procedure g_pobierz_skan_kod(var kod_scan : byte);
var
temp : byte;
begin

{pobranie informacji o klawiaturze}
temp := port[$64];

{sprawdzenie czy bufor nie jest pusty i czy bajt znajdujacy sie w
 porcie 60h pochodzi od klawiatury, jezeli ktoras z tych dwoch rzeczy sie
 nie zgadza odczytujemy z portu 60h wartosc poto aby go oproznic co pozwoli
 klawiaturze na zapisanie do niego kolejnych informacji, zapisujemy zero do
 otrzymanej poprzez parametr zmiennej i wychodzimy z procedury}
if ((temp and $01) = 0) then
                        begin
                        kod_scan := 0;
                        exit;
                        end;

if ((temp and $20) = 32) then
                        begin
                        temp := port[$60];
                        kod_scan := 0;
                        exit;
                        end;

{pobierz kod scan nacisnietego lub zwolnionego klawisza}
kod_scan := port[$60];

end; {koniec procedury g_pobierz_skan_kod}

{--------------}

procedure g_powtarzanie_klawiszy( liczba, opoznienie : byte);
begin
asm

mov ah, 03h        {laduj 03h do AH, numer funkcji przerwania 16h}
mov bl, liczba     {laduj liczba do BL, liczba powtorzen kodu klawiszy}
mov bh, opoznienie {laduj opoznienie do BH }
int 16h            {wywolaj przerwanie 16h}

end;
end; {koniec procedurey g_powtarzanie_klawiszy}

{--------------}

procedure g_sys_klawiatura( stan : boolean);
begin

if(stan = TRUE) then
   port[$21] := $00    {wlaczenie obslugi przerwania klawiatury}
   else
   port[$21] := $02;   {wylaczenie obslugi przerwania klawiatury}

end; {koniec procedury g_sys_klawiatura}

{--------------}

procedure g_pokaz_kursor( status : boolean);
begin

if (status = TRUE) then
                   asm
                   mov ax, 0001h  {laduj 0001h do AX}
                   int 33h        {wywolaj przerwanie 33h}
                   end else
                   asm
                   mov ax, 0002h  {laduj 0002h do AX}
                   int 33h        {wywolaj przerwanie 33h}
                   end;

end; {koniec procedury g_pokaz_kursor}

{--------------}

procedure g_pobierz_status_myszy(var lewy, srodkowy, prawy : boolean;
                                 var poz_x, poz_y : word);
var
temp : word;
temp_poz_x, temp_poz_y : word;
begin

asm
mov ax, 0003h                  {laduj 00003h do AX}
int 33h                        {wywolaj przerwanie 33h}
mov word ptr temp, bx          {laduj BX do temp}
mov word ptr temp_poz_x, cx    {laduj CX do temp_poz_x}
mov word ptr temp_poz_y, dx    {laduj DX do temp_poz_y}
end;

poz_x := temp_poz_x;
poz_y := temp_poz_y;

if ( (temp and $01) <> 0 ) then lewy := TRUE else lewy := FALSE;
if ( (temp and $02) <> 0 ) then prawy := TRUE else prawy := FALSE;
if ( (temp and $04) <> 0 ) then srodkowy := TRUE else srodkowy := FALSE;

end; {koniec procedury g_pobierz_status_myszy}

{--------------}

procedure g_wyswietl_tekst_13h( wsk_bufora : pointer; x, y : word; tekst : string; kolor : byte);
var
liczba_znakow_w_tekscie : byte;
licznik_znakow,licznik_bitow : byte;
licznik_bajtow : byte;
indeks : byte;
przesuniecie : word;
maska_bitowa : byte;
begin

{jezeli tekst lezy za nisko przerywamy prace procedury}
if((y + 8) > 199) then exit;

{obliczmy przesuniecie w buforze do pierwszego piksela tekstu}
przesuniecie := (y * 320) + x;

{pobieramy liczbe znakow w tekscie}
liczba_znakow_w_tekscie := ord(tekst[0]);

{rysujemy wszystkie znaki}
for licznik_znakow := 1 to liczba_znakow_w_tekscie do
begin

{jezeli napotykamy na spacje przechodzimy do kolejnego znaku}
if(tekst[licznik_znakow] = ' ') then
begin
x := x + 8;
if (x > 312) then break;
przesuniecie := (y * 320) + x;
continue;
end else {w przeciwnym wypadku sprawdzamy czy znak jest kropka,
          lub innym znakiem specjalnym}

if(tekst[licznik_znakow] = '.') then indeks := 0 else
if(tekst[licznik_znakow] = '-') then indeks := 63 else
if(tekst[licznik_znakow] = '+') then indeks := 64 else
if(tekst[licznik_znakow] = ',') then indeks := 65 else
if(tekst[licznik_znakow] = '/') then indeks := 66 else
if(tekst[licznik_znakow] = '*') then indeks := 67 else
if(tekst[licznik_znakow] = ':') then indeks := 68 else
if(tekst[licznik_znakow] = '=') then indeks := 69 else
if(tekst[licznik_znakow] = '_') then indeks := 70 else

{jesli nia nie jest, sprawdzamy czy jest cyfra}
if((tekst[licznik_znakow] >= '0') and
   (tekst[licznik_znakow] <= '9')) then
   indeks := ord(tekst[licznik_znakow]) - 47 else

{jesli nie jest cyfra to sprawdzamy czy jego kod pasuje do ktoregos
 ze znakow duzych liter}
if((tekst[licznik_znakow] >= 'A') and
   (tekst[licznik_znakow] <= 'Z')) then
   indeks := ord(tekst[licznik_znakow]) - 54 else

{jesli nie jest duza litera sprawdzamy czy jest mala litera}
if((tekst[licznik_znakow] >= 'a') and
   (tekst[licznik_znakow] <= 'z')) then
   indeks := ord(tekst[licznik_znakow]) - 60 else
begin
{jesli procedura wejdzie do tego bloku kodu oznaczac to bedzie, ze
 aktualnie ropatrywany znak nie jest obslugiwany przez procedure
 g_wyswietl_tekst, w takim wypadku przechodzimy do rozpatrzenia
 kolejnego znaku}
x := x + 8;
if (x > 312) then break;
przesuniecie := (y * 320) + x;
continue;
end;

{maska bitowa sluzaca do sledzenia ustawionych bitow w bajtach wzorca znaku}
maska_bitowa := $80;  {80h = 10000000b}

{malowanie znaku}
for licznik_bajtow := 0 to 7 do
begin
for licznik_bitow := 0 to 7 do
begin
if ((g_tab_znakow[indeks][licznik_bajtow] and maska_bitowa) = maska_bitowa)
 then
asm
les di, wsk_bufora         {laduj adres bufora wideo, segment do ES, offset do DI}
add di, przesuniecie       {dodaj przesuniecie do DI}
mov ah, kolor              {laduj kolor do AH}
mov byte ptr es:[di], ah   {laduj AH do komorki pamieci spod adresu ES:DI}
end;

{przesowamy ustawiony bit maski o jedna pozycje w prawo}
maska_bitowa := maska_bitowa shr 1;

{przechodzimy do kolejnego piksela malowanej lini}
przesuniecie := przesuniecie + 1;

end; {koniec petli for licznik_bitow}

{cofamy sie na poczatek lini i przeskakujemy jedna nizej}
przesuniecie := przesuniecie + 320 - 8;

{odswiezenie maski bitowej}
maska_bitowa := $80;  {80h = 10000000b}

end; {koniec petli for licznik_bajtow}

{ustawienie przesuniecia na pierwszy piksel kolejnego rysowanego znaku,
 przy okazji sprawdzamy czy nastepny znak wyjdzie za prawa krawedz ekranu,
 jesli tak, to przerywamy petle rysujaca znaki}
x := x + 8;
if (x > 312) then break;  {przerwanie petli for licznik_znakow}
przesuniecie := (y * 320) + x;

end; {koniec petli for licznik znakow}

end; {koniec procedury g_wyswietl_tekst_13h}

{--------------}

procedure g_ustaw_wzorzec_koloru(nr_wzorca : byte; c, z, n : byte);
begin

{okreslamy numer wzorca koloru ktory chcemy zmodyfikowac}
port[$3c8] := nr_wzorca;

{wysylamy do portu 3c9h intensywnosc podstawowych kolorow}
port[$3c9] := c;
port[$3c9] := z;
port[$3c9] := n;

end; { koniec procedury g_ustaw_wzorzec_koloru}

{--------------}

procedure g_pobierz_pam_dla_drugiego_bufora(var wsk_bufora : pointer);
var
wolna_pamiec : longint;
begin

{sprawdzamy czy system posiada wystarczajaco duzo wolnej pamieci}
wolna_pamiec := maxavail;
if(wolna_pamiec < 64000) then exit;

{pobranie pamieci}
getmem(wsk_bufora, 64000);

end; {koniec procedury g_pobierz_pam_dla_drugiego_bufora}

{--------------}

procedure g_zwolnij_pam_bufora(var wsk_bufora : pointer);
begin

freemem(wsk_bufora, 64000);

end; {koniec procedury g_zwolnij_pam_bufora}

{--------------}

procedure g_kopiuj_bufor( buf_docelowy, buf_zrodlowy : pointer);
begin
asm

push ds               {odluz na stos wartosc z DS}
lds si, buf_zrodlowy  {laduj adres bufora zrodlowego, segment do DS,
                       offset do SI}
les di, buf_docelowy  {laduj adres bufora docelowego, segment do ES,
                       offset do DI}
mov cx, 32000         {laduj liczbe 32000 do CX, liczba powturzen
                       instrukcji movsw}
cld                   {zeruj znacznik kierunku - adresy rosnace}

rep movsw             {kopiuj dwa bajty spod adresu DS:SI do miejsca
                       w pamieci okreslonego przez adres ES:DI}

pop ds                {laduj wartosc ze stosu do DS}

end;
end; {koniec procedury g_kopiuj_bufor}

{--------------}

procedure g_czekaj_na_powrot_pionowy;
begin
asm

  mov dx, 3dah           {laduj 3DAh do DX}

@trwa_powrot:            {definicja etykiety trwa_powrot}
  in  al, dx             {laduj do AL wartosc z portu 3DAh}
  test al, 00001000b     {sprawdzenie 3-go bitu AL}
  jnz @trwa_powrot       {jezeli wynik testu jest nie zerowy, oznacza
                          to trwanie powrotu pionowego i skok do etykiety
                          trwa_powrot}

@nie_ma_powrotu:          {definicja etykiety nie_ma_powrotu}
  in al, dx               {laduj do AL wartosc z portu 3DAh}
  test al, 00001000b      {sprawdzenie 3-go bitu AL}
  jz @nie_ma_powrotu      {jezeli wynik testu jest zerem, oznacza to brak
                           powrotu pionowego i skok do etykiety
                           nie_ma_powrotu}

end;
end; {koniec procedury g_czekaj_na_powrot_pionowy}

{--------------}

procedure g_wypelnij_bufor(adres : pointer; kolor : byte);
begin
asm

les di, adres    {laduj adres bufora, segment do ES, offset do DI}
mov cx, 32000    {zaladuj 32000 do CX}
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_wypelnij_bufor}

{--------------}

procedure g_pobierz_palete_VGA(var paleta : paleta_kolorow);
var
licznik : byte;
begin

{checmy odczytac cala palete kolorow, dlatego tez ropoczynamy
 jej czytanie od pierwszego wzorca koloru}
port[$3c7] := 0;

{odczytanie palety kolorow}
for licznik := 0 to 255 do
begin

paleta[licznik].czerwony := port[$3c9];
paleta[licznik].zielony := port[$3c9];
paleta[licznik].niebieski := port[$3c9];

end; {koniec petli for}

end; {koniec procedury g_pobierz_palete_VGA}

{--------------}

procedure g_pobierz_wzorzec_koloru(nr_wzorca : byte; var wzorzec : wzorzec_koloru);
begin

{okreslamy numer wzorca koloru ktory chcemy pobrac}
port[$3c7] := nr_wzorca;

{pobieramy z portu 3c9h intensywnosc podstawowych kolorow}
wzorzec.czerwony  := port[$3c9];
wzorzec.zielony   := port[$3c9];
wzorzec.niebieski := port[$3c9];

end; { koniec procedury g_pobierz_wzorzec_koloru}

{--------------}

procedure g_wygas_ekran(przerwa : byte);
var
licznik1, licznik2 : byte;
wzorzec : wzorzec_koloru;
begin

for licznik2 := 0 to 63 do
begin

g_czekaj_na_powrot_pionowy;
{zmiejszamy wartosc kazdego pola intensywnosci barwy o 1}
for licznik1 := 0 to 255 do
begin

g_pobierz_wzorzec_koloru(licznik1, wzorzec);

if(wzorzec.czerwony > 0) then dec(wzorzec.czerwony);
if(wzorzec.zielony > 0) then dec(wzorzec.zielony);
if(wzorzec.niebieski > 0) then dec(wzorzec.niebieski);

g_ustaw_wzorzec_koloru(licznik1, wzorzec.czerwony,
                      wzorzec.zielony, wzorzec.niebieski);

end; {koniec petli for licznik1}

if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik2}

end; {koniec procedury g_wygas_ekran}

{--------------}

procedure g_rozjasnij_ekran(var paleta_k : paleta_kolorow; przerwa : byte);
var
licznik1, licznik2 : byte;
wzorzec : wzorzec_koloru;
begin

for licznik2 := 0 to 63 do
begin

g_czekaj_na_powrot_pionowy;

{zwiekszamy wartosc kazdego pola intensywnosci barwy o 1}
for licznik1 := 0 to 255 do
begin

g_pobierz_wzorzec_koloru(licznik1, wzorzec);

if(wzorzec.czerwony < paleta_k[licznik1].czerwony) then
   inc(wzorzec.czerwony);

if(wzorzec.zielony < paleta_k[licznik1].zielony) then
   inc(wzorzec.zielony);

if(wzorzec.niebieski < paleta_k[licznik1].niebieski) then
   inc(wzorzec.niebieski);

g_ustaw_wzorzec_koloru(licznik1, wzorzec.czerwony,
                      wzorzec.zielony, wzorzec.niebieski);

end; {koniec petli for licznik1}


if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik2}

end; {koniec procedury g_rozjasnij_ekran}

{--------------}

procedure g_topnienie_ekranu(kolor : byte);
var
licznik : longint;
begin

for licznik := 0 to 800000 do
     begin
     g_rysuj_piksel_13h(random(320), random(200), kolor);
     if((licznik mod 10000) = 0) then delay(2);
     end;

end; {koniec procedury g_topnienie_ekranu}

{--------------}

procedure g_zalej_ekran( kolor, przerwa : byte);
var
poz_y_linii : array[0..319] of byte;
rozmiar_fragmentow : array[0..319] of byte;
licznik1, licznik2 : word;
begin

{ustalmy poczatek wszystkich linii na 0 oraz losowo wybieramy predkosc
 malowania kazdej z linii}
for licznik1 := 0 to 319 do
begin
poz_y_linii[licznik1] := 0;
rozmiar_fragmentow[licznik1] := random(7) + 2;
end; {koniec petli for licznik1}

{rysowanie linii}
for licznik1 := 0 to 99 do
begin
for licznik2 := 0 to 319 do
begin

if(poz_y_linii[licznik2] + rozmiar_fragmentow[licznik2] < 200) then
 begin
  g_rysuj_pionowa_linia_13h(licznik2,
                            poz_y_linii[licznik2],
                            poz_y_linii[licznik2] +
                            rozmiar_fragmentow[licznik2],
                            kolor);
  inc(poz_y_linii[licznik2], rozmiar_fragmentow[licznik2]);
 end else {koniec bloku if}
 begin
  g_rysuj_pionowa_linia_13h(licznik2,
                            poz_y_linii[licznik2],
                            199,
                            kolor);
 end; {koniec bloku else}

end; {koniec petli for licznik2}

if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik1}

end; {koniec procedury g_zalej_ekran}

{--------------}

function g_zresetuj_SB( baza : byte):boolean;
begin

baza := baza shl 4;

port_2x6 := $206 + baza;
port_2xA := $20A + baza;
port_2xC := $20C + baza;
port_2xE := $20E + baza;

port[port_2x6] := 1;
delay(5);
port[port_2x6] := 0;
delay(5);

if ((port[port_2xE] and 128 = 128) and (port[port_2xA] = $AA)) then
     g_zresetuj_SB := TRUE else
     g_zresetuj_SB := FALSE;

end; {koniec funkcji g_zresetuj_SB}

{--------------}

procedure g_zapisz_do_SB(data : byte);
begin

{jezli 7 bit portu 2xCh jest ustawiony wykonujemy pusta instrukcje -> ';'}
while (port[port_2xC] and 128 = 128) do ;

{wprowadzenie wartosci do karty dzwiekowej}
port[port_2xC] := data;

end; {koniec procedury g_zapisz_do_SB}

{--------------}

procedure g_odczytaj_z_SB(var data : byte);
begin

{jezli 7 bit portu 2xEh jest wyzerowany wykonujemy pusta instrukcje -> ';'}
while (port[port_2xE] and 128 = 0) do ;

{pobranie wartosci z karty dzwiekowej}
data := port[port_2xA];

end; {koniec procedury g_odczytaj_z_SB}

{--------------}

procedure g_wlacz_glosniki;
begin

g_zapisz_do_SB($D1);

end; {koniec procedury g_wlacz_glosniki}

{--------------}

procedure g_wylacz_glosniki;
begin

g_zapisz_do_SB($D3);

end; {koniec procedury g_wylacz_glosniki}

{--------------}

procedure g_przestan_odtwarzac;
begin

g_zapisz_do_SB($D0);

end; {koniec procedury g_przestan_odtwarzac}

{--------------}

procedure g_laduj_WAV(var data : fala_dzwiekowa; szciezka : string);
var
plik : file;
licznik, wynik : word;
licznik2 : word;
begin

assign(plik, szciezka);
reset(plik, 1);
licznik := sizeof(naglowek_WAV);

{odczytanie naglowka pliku - 44 bajty}
blockread(plik, data.naglowek, licznik, wynik);

{sparwdzamy czy system posiada dosc wolnej pamieci do przechowywania
 ladowanych danych dzwiekowych, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < data.naglowek.rozmiar_danych_dzwiekowych) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla bufora danych opisujacych fale dzwiekowa}
getmem(data.wsk_bufora, data.naglowek.rozmiar_danych_dzwiekowych);

{odczytanie danych dwiekowych}
licznik := data.naglowek.rozmiar_danych_dzwiekowych;
blockread(plik, data.wsk_bufora^, licznik, wynik);

{zakniecie pliku}
close(plik);

end; {koniec procedury g_laduj_WAV}

{--------------}

procedure g_zwolnij_pam_w( data : fala_dzwiekowa);
begin

{zwolnienie pamieci}
freemem(data.wsk_bufora, data.naglowek.rozmiar_danych_dzwiekowych);

end; {koniec procedury g_zwolnij_pam_w}

{--------------}

procedure g_odegraj_WAV( fala : fala_dzwiekowa; czestotliwosc: word);
var
stala_czasowa: byte;
adres, strona: Word;
rozmiar : word;
begin

  { obliczenie adresu i strony bufora dzwiekowego}
  adres  := seg(fala.wsk_bufora^) shl 4 + ofs(fala.wsk_bufora^);
  strona := (seg(fala.wsk_bufora^) + ofs(fala.wsk_bufora^) shr 4) shr 12;

  {przepisanie rozmiaru bufora dzwiekowego do zmiennej dwubajtowej}
  rozmiar := fala.naglowek.rozmiar_danych_dzwiekowych;

  {uruchomienie przeplywu danych z bufora dzwienkowego poprzez kanal
   DMA numer 1 do karty dzwiekowej}

  {blokujemy kanal numer 1}
  port[$00A] := $05;

  {ustalmy tryb transmisji danych przez kontroler DMA na "S", brak
  samoprogramowania, odczyt z pamieci, adresy rosnace}
  port[$00B] := $49;

  {podajmy strone bufora dzwiekowego}
  port[$083] := strona;

  {zerujemy przerzutnik, przed zapisem wartosci dwubajtowej}
  port[$00C] := 00;

  {poadajemy kontrolerowi DMA adres bufora dzwiekowego}
  port[$002] := lo(adres);
  port[$002] := hi(adres);

  {zerujemy przezrzutnik przez zapisem kolejnem wartosci dwubajtowej}
  port[$00C] := 00;

  {podajemy kontrolerowi liczbe bajtow jaka ma przeslac}
  port[$003] := lo(rozmiar);
  port[$003] := hi(rozmiar);

  {odblokowanie kanalu DMA numer 1  - ropoczecie transmisji danych}
  port[$00A] := $01;

  {obliczenie i ustawienie czestotliwosci odtwarzania dzwieku dla
   karty dzwiekowej }
  stala_czasowa := 256 - (1000000 div czestotliwosc);
  g_zapisz_do_SB($40);
  g_zapisz_do_SB(stala_czasowa);

  {ustalenie typu sampli i ich liczby}
  g_zapisz_do_SB($14);
  g_zapisz_do_SB(lo(rozmiar));
  g_zapisz_do_SB(hi(rozmiar));

end; {koniec procedury g_odegraj_WAV}

{--------------}

procedure g_inicjuj_tab_sin_i_cos;
var
licznik : word;
begin
for licznik := 0 to 359 do
begin
tab_sin[licznik] := sin((PI*licznik)/180);
tab_cos[licznik] := cos((PI*licznik)/180);
end; {koniec petli for}

end; {koniec procedury g_inicjuj_tab_sin_i_cos}

{--------------}

procedure g_oblicz_dlugosc_wektora(var a, b : wierzcholek; var dlugosc : real);
begin

dlugosc := sqrt( (b.x - a.x)*(b.x - a.x) +
                 (b.y - a.y)*(b.y - a.y) +
                 (b.x - a.z)*(b.x - a.z)
                );

end; {koniec procedury g_oblicz_dlugosc_wektora}

{--------------}

procedure g_dodaj_wektory(var a, b, c : wierzcholek);
begin

c.x := a.x + b.x;
c.y := a.y + b.y;
c.z := a.z + b.z;

end; {koniec procedury g_dodaj_wektory}

{--------------}

procedure g_odejmij_wektory(var a, b, c : wierzcholek);
begin

c.x := a.x - b.x;
c.y := a.y - b.y;
c.z := a.z - b.z;

end; {koniec procedury g_odejmij_wektory}

{--------------}

procedure g_pomnuz_wektor_przez_liczbe(var a : wierzcholek;
                                       liczba : real;
                                       var b : wierzcholek);
begin

b.x := liczba * a.x;
b.y := liczba * a.y;
b.z := liczba * a.z;

end; {koniec procedury g_pomnuz_wektor_przez_liczbe}

{--------------}

procedure g_oblicz_iloczyn_skalarny_wektorow(var a, b : wierzcholek;
                                             var wynik : real);
begin

wynik := a.x*b.x + a.y*b.y + a.z*b.z;

end; {koniec procedury g_oblicz_iloczyn_skalarny_wektorow}

{--------------}

procedure g_oblicz_wektorowe_mnozenie_wektorow(var a, b, c : wierzcholek);
begin

c.x := a.y*b.z - a.z*b.y;
c.y := a.z*b.x - a.x*b.z;
c.z := a.x*b.y - a.y*b.x;

end; {koniec procedury g_oblicz_wektorowe_mnozenie_wektorow}

{--------------}

procedure g_obroc_wierzcholki_wokol_osi_x(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy wierzcholki o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin
pomoc.y := tab^.y*tab_cos[kat] - tab^.z*tab_sin[kat];
pomoc.z := tab^.y*tab_sin[kat] + tab^.z*tab_cos[kat];

tab^.y := pomoc.y;
tab^.z := pomoc.z;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_wierzcholki_wokol_osi_x}

{--------------}

procedure g_obroc_wierzcholki_wokol_osi_y(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy wierzcholki o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin
pomoc.x := tab^.z*tab_sin[kat] + tab^.x*tab_cos[kat];
pomoc.z := tab^.z*tab_cos[kat] - tab^.x*tab_sin[kat];

tab^.x := pomoc.x;
tab^.z := pomoc.z;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_wierzcholki_wokol_osi_y}

{--------------}

procedure g_obroc_wierzcholki_wokol_osi_z(tab : wskaznik_na_w;
                                          kat : integer;
                                          ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy wierzcholki o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin
pomoc.x := tab^.y*tab_sin[kat] + tab^.x*tab_cos[kat];
pomoc.y := tab^.y*tab_cos[kat] - tab^.x*tab_sin[kat];

tab^.x := pomoc.x;
tab^.y := pomoc.y;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_wierzcholki_wokol_osi_z}

{--------------}

procedure g_obroc_trojkaty_wokol_osi_x(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy trojkat o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
pomoc.y := tab^[0].y*tab_cos[kat] - tab^[0].z*tab_sin[kat];
pomoc.z := tab^[0].y*tab_sin[kat] + tab^[0].z*tab_cos[kat];
tab^[0].y := pomoc.y;
tab^[0].z := pomoc.z;

{wierzcholek 2}
pomoc.y := tab^[1].y*tab_cos[kat] - tab^[1].z*tab_sin[kat];
pomoc.z := tab^[1].y*tab_sin[kat] + tab^[1].z*tab_cos[kat];
tab^[1].y := pomoc.y;
tab^[1].z := pomoc.z;

{wierzcholek 3}
pomoc.y := tab^[2].y*tab_cos[kat] - tab^[2].z*tab_sin[kat];
pomoc.z := tab^[2].y*tab_sin[kat] + tab^[2].z*tab_cos[kat];
tab^[2].y := pomoc.y;
tab^[2].z := pomoc.z;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_trojkaty_wokol_osi_x}

{--------------}

procedure g_obroc_trojkaty_wokol_osi_y(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy trojkat o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
pomoc.x := tab^[0].z*tab_sin[kat] + tab^[0].x*tab_cos[kat];
pomoc.z := tab^[0].z*tab_cos[kat] - tab^[0].x*tab_sin[kat];
tab^[0].x := pomoc.x;
tab^[0].z := pomoc.z;

{wierzcholek 2}
pomoc.x := tab^[1].z*tab_sin[kat] + tab^[1].x*tab_cos[kat];
pomoc.z := tab^[1].z*tab_cos[kat] - tab^[1].x*tab_sin[kat];
tab^[1].x := pomoc.x;
tab^[1].z := pomoc.z;

{wierzcholek 3}
pomoc.x := tab^[2].z*tab_sin[kat] + tab^[2].x*tab_cos[kat];
pomoc.z := tab^[2].z*tab_cos[kat] - tab^[2].x*tab_sin[kat];
tab^[2].x := pomoc.x;
tab^[2].z := pomoc.z;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_trokaty_wokol_osi_y}

{--------------}

procedure g_obroc_trojkaty_wokol_osi_z(tab : wskaznik_na_t;
                                       kat : integer;
                                       ile : word);
var
licznik : word;
pomoc : wierzcholek;
begin

{jezeli obracamy trojkat o kat ujemny}
if(kat < 0) then kat := kat + 360;

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
pomoc.x := tab^[0].y*tab_sin[kat] + tab^[0].x*tab_cos[kat];
pomoc.y := tab^[0].y*tab_cos[kat] - tab^[0].x*tab_sin[kat];
tab^[0].x := pomoc.x;
tab^[0].y := pomoc.y;

{wierzcholek 2}
pomoc.x := tab^[1].y*tab_sin[kat] + tab^[1].x*tab_cos[kat];
pomoc.y := tab^[1].y*tab_cos[kat] - tab^[1].x*tab_sin[kat];
tab^[1].x := pomoc.x;
tab^[1].y := pomoc.y;

{wierzcholek 3}
pomoc.x := tab^[2].y*tab_sin[kat] + tab^[2].x*tab_cos[kat];
pomoc.y := tab^[2].y*tab_cos[kat] - tab^[2].x*tab_sin[kat];
tab^[2].x := pomoc.x;
tab^[2].y := pomoc.y;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_obroc_trojkaty_wokol_osi_z}

{--------------}

procedure g_przesun_wierzcholki(tab : wskaznik_na_w;
                                dx,dy,dz : real;
                                ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin

tab^.x := tab^.x + dx;
tab^.y := tab^.y + dy;
tab^.z := tab^.z + dz;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_przesun_wierzcholki}

{--------------}

procedure g_przesun_trojkaty(tab : wskaznik_na_t;
                             dx,dy,dz : real;
                             ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
tab^[0].x := tab^[0].x + dx;
tab^[0].y := tab^[0].y + dy;
tab^[0].z := tab^[0].z + dz;

{wierzcholek 2}
tab^[1].x := tab^[1].x + dx;
tab^[1].y := tab^[1].y + dy;
tab^[1].z := tab^[1].z + dz;

{wierzcholek 3}
tab^[2].x := tab^[2].x + dx;
tab^[2].y := tab^[2].y + dy;
tab^[2].z := tab^[2].z + dz;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_przesun_trojkaty}

{--------------}

procedure g_skaluj_wierzcholki(tab : wskaznik_na_w;
                               skala : real;
                               ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin

tab^.x := tab^.x * skala;
tab^.y := tab^.y * skala;
tab^.z := tab^.z * skala;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_skaluj_wierzcholki}

{--------------}

procedure g_skaluj_trojkaty(tab : wskaznik_na_t;
                            skala : real;
                            ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
tab^[0].x := tab^[0].x * skala;
tab^[0].y := tab^[0].y * skala;
tab^[0].z := tab^[0].z * skala;

{wierzcholek 2}
tab^[1].x := tab^[1].x * skala;
tab^[1].y := tab^[1].y * skala;
tab^[1].z := tab^[1].z * skala;

{wierzcholek 3}
tab^[2].x := tab^[2].x * skala;
tab^[2].y := tab^[2].y * skala;
tab^[2].z := tab^[2].z * skala;

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_skaluj_trojkaty}

{--------------}

procedure g_rzutuj_wierzcholki(tab : wskaznik_na_w;
                               ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin
tab^.x := srodek_e_x + ((tab^.x * odleglosc_do_PR) / tab^.z);
tab^.y := srodek_e_y - ((tab^.y * odleglosc_do_PR) / tab^.z);

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_rzutuj_wierzcholki}

{--------------}

procedure g_rzutuj_trojkaty( tab : wskaznik_na_t;
                             ile : word);
var
licznik : word;
begin

for licznik := 0 to ile - 1 do
begin

{wierzcholek 1}
tab^[0].x := srodek_e_x + ((tab^[0].x * odleglosc_do_PR) / tab^[0].z);
tab^[0].y := srodek_e_y - ((tab^[0].y * odleglosc_do_PR) / tab^[0].z);
{wierzcholek 2}
tab^[1].x := srodek_e_x + ((tab^[1].x * odleglosc_do_PR) / tab^[1].z);
tab^[1].y := srodek_e_y - ((tab^[1].y * odleglosc_do_PR) / tab^[1].z);
{wierzcholek 3}
tab^[2].x := srodek_e_x + ((tab^[2].x * odleglosc_do_PR) / tab^[2].z);
tab^[2].y := srodek_e_y - ((tab^[2].y * odleglosc_do_PR) / tab^[2].z);

inc(tab);
end; {koniec petli for}

end; {koniec procedury g_rzutuj_trojkaty}

{--------------}

procedure g_rysuj_piksel_w_buforze(buf : pointer; x,y : word; kolor:byte);
begin
asm

les di, buf              {zaladuj do ES czesc segmentowa adresu zapisanego
                          w parametrze buf a czesc offsetowa umiesc w DI}
mov ax, y                {zaladuj y do AX}
mov si, ax               {zaladuj AX do SI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl si, 6                {przesun bity rejestru SI 6 pozycji w lewo}
add di, si               {dodaj SI do DI}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz do komorki spod adresu ES:DI
                          wartosc rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_w_buforze}

{--------------}

procedure g_przygotuj_trojkaty_do_rysowania_m_punktowa(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_w;
                                        ile : word;
                                        var liczba_widocznych  : word);
var
licznik_t, licznik_w : word;
pomoc : wierzcholek;
wektor_a, wektor_b, wektor_normalny : wierzcholek;
wynik : real;

begin
liczba_widocznych := 0;

for licznik_t := 0 to ile - 1 do
begin

{sprawdzenie widocznosci trojkata}
if (widocznosc_t <> 3) then
begin

{obliczenie wektora normalnego trojkata}
g_odejmij_wektory(zrodlo^[0], zrodlo^[1], wektor_a);
g_odejmij_wektory(zrodlo^[2], zrodlo^[1], wektor_b);
g_oblicz_wektorowe_mnozenie_wektorow(wektor_a, wektor_b, wektor_normalny);

{oblicznie iloczynu skalarnego wektora
 normalnego trojkata i wektora kamery}
g_oblicz_iloczyn_skalarny_wektorow(wektor_normalny, zrodlo^[0], wynik);

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 1}
if(widocznosc_t = 1) then
if(wynik >= 0) then
begin
inc(zrodlo);
continue;
end;

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 2}
if(widocznosc_t = 2) then
if(wynik <= 0) then
begin
inc(zrodlo);
continue;
end;

end; {koniec bloku if (widocznosc_t <> }

{analiza wierzcholkow trojkata}
for licznik_w := 0 to 2 do
begin

{sprawdzenie czy wierzcholek znajduje sie przed plaszczyzna obcinajaca,
jezeli tak nie jest przystepujemy do analizy kolejnego wierzcholka}
if (zrodlo^[licznik_w].z < p_obcinania) then continue;

{rzutowanie wierzcholka}
g_rzutuj_wierzcholki(@zrodlo^[licznik_w], 1);

{sprawdzenie czy rzutowany wierzcholek
 znajduje sie w polu widzenia ekranu}
if ( (round(zrodlo^[licznik_w].x) < 0)   or
     (round(zrodlo^[licznik_w].x) > 319) or
     (round(zrodlo^[licznik_w].y) < 0)   or
     (round(zrodlo^[licznik_w].y) > 199)) then continue;

{wierzcholek spelnia wszystkie warunki wyswietlenia, dodajemy go do
 bufora roboczego wierzcholkow, zwiekszamy licznik widocznych
 wierzcholkow i przesowamy wskaznik celu na kolejne puste miejsce bufora
 wierzcholkow}
cel^ := zrodlo^[licznik_w];
inc(liczba_widocznych);
inc(cel);

end; {koniec petli for licznik_w}

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik_t}

end; {koniec procedury g_przygotuj_trojkaty_do_rysowania_m_punktowa}

{--------------}

procedure g_wyswietl_trojkaty_m_punktowa(buf : pointer;
                                         zrodlo : wskaznik_na_w;
                                         ile : word;
                                         kolor : byte);
var
licznik : word;

begin
for licznik := 0 to ile - 1 do
begin

g_rysuj_piksel_w_buforze(buf, round(zrodlo^.x), round(zrodlo^.y), kolor);
inc(zrodlo);

end; {koniec petli for licznik}

end; {koniec procedury g_wyswietl_trojkaty_m_punktowa}

{--------------}

function g_pobierz_znak(liczba : real):integer;
begin

    if (liczba > 0) then g_pobierz_znak := 1;
    if (liczba < 0) then g_pobierz_znak := -1;
    if (liczba = 0) then g_pobierz_znak := 0;

end; {koniec funkcji g_pobierz_znak}

{--------------}

procedure g_rysuj_linie_w_buforze(bufor : pointer;
                                  x1, y1, x2, y2 : longint;
                                  kolor : byte);
var
licznik, s, d1x, d1y, d2x : integer;
d2y, r_x, r_y, m, n:integer;

begin

{oblicznie odleglosci pomiedzy punktami na osi X i Y}
r_x := x2 - x1;
r_y := y2 - y1;

{sprawdzenie znaku}
d1x := g_pobierz_znak(r_x);
d1y := g_pobierz_znak(r_y);

{okreslenie kierunku rysowania linii}
d2x := g_pobierz_znak(r_x);
d2y := 0;
m := abs(r_x);
n := abs(r_y);

if (m <= n) then
begin
d2x := 0 ;
d2y := g_pobierz_znak(r_y);
m := abs(r_y);
n := abs(r_x);
end;

s := m shr 1; {podziel m prze 2}

{rysowanie linii}
for licznik := 0 to m do
begin

g_rysuj_piksel_w_buforze(bufor, x1, y1, kolor);

{okreslenie wspolrzednych kolejnego piksela linii}
  s := s + n;

  if (s >= m) then
  begin
  s  := s - m;
  x1 := x1 + d1x;
  y1 := y1 + d1y;
  end
  else
  begin
  x1 := x1 + d2x;
  y1 := y1 + d2y;
  end;

end; {koniec petli for}

end; {koniec procedury g_rysuj_linie_w_buforze}

{--------------}

function g_przytnij_linie(w1,w2 : wierzcholek; var w3, w4 : wierzcholek ):boolean;
var
a, b : real;
kopia_w1, kopia_w2 : wierzcholek;
bx_ax, by_ay : real;
x0, x319, y0, y199 : real;
begin

g_przytnij_linie := FALSE;

{sprawdzenie czy cala linia znajduje sie w polu widzenia ekranu}
if((w1.x >= 0 ) and (w1.x <= 319)) and
  ((w1.y >= 0 ) and (w1.y <= 199)) and
  ((w2.x >= 0 ) and (w2.x <= 319)) and
  ((w2.y >= 0 ) and (w2.y <= 199)) then
  begin
  w3 := w1;
  w4 := w2;
  g_przytnij_linie := TRUE;
  exit;
  end;

{sprawdzenie czy cala linia lezy poza polem widzenia ekranu}
if((w1.x < 0)   and (w2.x < 0))   then exit;
if((w1.x > 319) and (w2.x > 319)) then exit;
if((w1.y < 0)   and (w2.y < 0))   then exit;
if((w1.y > 199) and (w2.y > 199)) then exit;

{sprawdzenie wyjatku gdy linia jest prostopadla do osi X}
if(w1.x = w2.x) then
begin
w3 := w1;
w4 := w2;

  if(w1.y < 0) then
  begin
  w3.y := 0;
  w3.x := w1.x;
  end;
     if(w2.y < 0) then
     begin
     w4.y := 0;
     w4.x := w2.x;
     end;
        if(w1.y > 199) then
        begin
        w3.y := 199;
        w3.x := w1.x;
        end;
           if(w2.y > 199) then
           begin
           w4.y := 199;
           w4.x := w2.x;
           end;

g_przytnij_linie := TRUE;
exit;
end;

{sprawdzenie wyjatku gdy linia jest prostopadla do osi Y}
if(w1.y = w2.y) then
begin
w3 := w1;
w4 := w2;

  if(w1.x < 0) then
  begin
  w3.x := 0;
  w3.y := w1.y;
  end;
     if(w2.x < 0) then
     begin
     w4.x := 0;
     w4.y := w2.y;
     end;
        if(w1.x > 319) then
        begin
        w3.x := 319;
        w3.y := w2.y;
        end;
           if(w2.x > 319) then
           begin
           w4.x := 319;
           w4.y := w2.y;
           end;

g_przytnij_linie := TRUE;
exit;
end;

{skopiowanie wierzcholkow}
kopia_w1 := w1;
kopia_w2 := w2;

{odwrucenie wartosci wspolrzednych y punktow koncowych linii}
kopia_w1.y := -kopia_w1.y;
kopia_w2.y := -kopia_w2.y;

by_ay := (kopia_w2.y - kopia_w1.y);
bx_ax := (kopia_w2.x - kopia_w1.x);

{obliczenie wspolczynnika kierunkowego prostej}
a := by_ay/bx_ax;

{obliczenie parametru b prostej}
b := (((-kopia_w1.x)*by_ay) - ((bx_ax)*(-kopia_w1.y))) / bx_ax;


{oblicznie punktu przeciecia linii z karawedziami ekranu}
x0 := b;                       {z prosta x = 0,   lewa krawedz ekranu}
x319 := a*319 + b;             {z prosta x = 319, prawa krawedz ekranu}
y0 := (-b)/a;                  {z prosta y = 0,   gorna krawedz ekranu}
y199 := ((-199)+(-b))/a;       {z prosta y = 199, dolna krawedz ekranu}


{ -- przeciecie z lewa krawedzia ekranu --
 sprawdzenie czy wartosc wspolrzednej y punktu przeciecia z lewa
 krawedzia ekranu miesci sie w przedziale <0, -199>, jesli tak jest to
 sprawdzamy ktory koniec linii jest blizej krawedzi i modyfikujemy
 jego wspolrzedne}
if((x0 <= 0) and (x0 >= -199)) then
begin

 if (w1.x < 0) then
                 begin
                 w1.x := 0;
                 w1.y := -x0;
                 end;

 if (w2.x < 0) then
                 begin
                 w2.x := 0;
                 w2.y := -x0;
                 end;

g_przytnij_linie := TRUE;
end;


{ -- przeciecie z prawo krawedzia ekranu --
 sprawdzenie czy wartosc wspolrzednej y punktu przeciecia z prawa
 krawedzia ekranu miesci sie w przedziale <0, -199>, jesli tak jest to
 sprawdzamy ktory koniec linii jest blizej krawedzi i modyfikujemy
 jego wspolrzedne}
if((x319 <= 0) and (x319 >= -199)) then
begin

 if (w1.x > 319) then
                 begin
                 w1.x := 319;
                 w1.y := -x319;
                 end;

 if (w2.x > 319) then
                 begin
                 w2.x := 319;
                 w2.y := -x319;
                 end;

g_przytnij_linie := TRUE;
end;

{ -- przeciecie z gorna krawedzia ekranu --
 sprawdzenie czy wartosc wspolrzednej x punktu przeciecia z gorna
 krawedzia ekranu miesci sie w przedziale <0, 319>, jesli tak jest to
 sprawdzamy ktory koniec linii jest blizej krawedzi i modyfikujemy
 jego wspolrzedne}
if((y0 >= 0) and (y0 <= 319)) then
begin

 if (w1.y < 0) then
                 begin
                 w1.x := y0;
                 w1.y := 0;
                 end;

 if (w2.y < 0) then
                 begin
                 w2.x := y0;
                 w2.y := 0;
                 end;

g_przytnij_linie := TRUE;
end;


{ -- przeciecie z dolna krawedzia ekranu --
 sprawdzenie czy wartosc wspolrzednej x punktu przeciecia z dolna
 krawedzia ekranu miesci sie w przedziale <0, 319>, jesli tak jest to
 sprawdzamy ktory koniec linii jest blizej krawedzi i modyfikujemy
 jego wspolrzedne}
if((y199 >= 0) and (y199 <= 319)) then
begin

 if (w1.y > 199) then
                 begin
                 w1.x := y199;
                 w1.y := 199;
                 end;

 if (w2.y > 199) then
                 begin
                 w2.x := y199;
                 w2.y := 199;
                 end;

g_przytnij_linie := TRUE;
end;

{zapisanie nowych wspolrzednych punktu poczatkowego i koncowego linii}
w3 := w1;
w4 := w2;

end; {koniec funkcji g_przytnij_linie}

{--------------}

procedure g_przygotuj_trojkaty_do_rysowania_m_siatkowa(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_w;
                                        ile : word;
                                        var liczba_widocznych  : word);
var
licznik_t, licznik_w : word;
wektor_a, wektor_b, wektor_normalny : wierzcholek;
wynik : real;
za_czy_przed_po : array[0..2] of boolean;
licznik_z : byte;
nowe_wierzcholki : array[0..3] of wierzcholek;
licznik_nowych_w : byte;
kolejny : byte;
wsp_z : real;
zapis : byte;

begin
liczba_widocznych := 0;

for licznik_t := 0 to ile - 1 do
begin

{gromadzimy informacje o polozeniu wierzcholkow trojkata}
for licznik_z := 0  to 2 do
if(zrodlo^[licznik_z].z < p_obcinania) then
   za_czy_przed_po[licznik_z] := TRUE else
   za_czy_przed_po[licznik_z] := FALSE;

{sprawdzamy czy trojkat lezy za plaszczyzna obcinania,
jesli tak jest to przechodzimy do kolejnego trojkata}
if((za_czy_przed_po[0] = TRUE) and
   (za_czy_przed_po[1] = TRUE) and
   (za_czy_przed_po[2] = TRUE)) then
                              begin
                              inc(zrodlo);
                              continue;
                              end;

{sprawdzenie widocznosci trojkata}
if (widocznosc_t <> 3) then
begin

{obliczenie wektora normalnego trojkata}
g_odejmij_wektory(zrodlo^[0], zrodlo^[1], wektor_a);
g_odejmij_wektory(zrodlo^[2], zrodlo^[1], wektor_b);
g_oblicz_wektorowe_mnozenie_wektorow(wektor_a, wektor_b, wektor_normalny);

{oblicznie iloczynu skalarnego wektora
 normalnego trojkata i wektora kamery}
g_oblicz_iloczyn_skalarny_wektorow(wektor_normalny, zrodlo^[0], wynik);

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 1}
if(widocznosc_t = 1) then
if(wynik >= 0) then
begin
inc(zrodlo);
continue;
end;

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 2}
if(widocznosc_t = 2) then
if(wynik <= 0) then
begin
inc(zrodlo);
continue;
end;

end; {koniec bloku if (widocznosc_t <> }


licznik_nowych_w := 0;

{analiza wierzcholkow trojkata}
for licznik_w := 0 to 2 do
begin

{jezeli wierzcholek znajduje sie przed plaszczyzna obciania}
if(za_czy_przed_po[licznik_w] = FALSE) then
begin
nowe_wierzcholki[licznik_nowych_w] := zrodlo^[licznik_w];
licznik_nowych_w := licznik_nowych_w + 1;
end;

{zapisujemy do zmiennej kolejny indeks nastepnego wierzcholka}
kolejny := (licznik_w + 1) mod 3;

{jezeli polozenie wzgledem plaszczyzny obcinania aktualnie analizowanego
 wierzcholka jest rozne od polozenia nastepnego wierzcholka trojkata,
 musimy obliczyc wspolrzedne punkty w ktorym linia poprowadzona
 pomiedzy dwoma danymi wierzcholkami przetnie plaszczyzne obcinania}
if(za_czy_przed_po[licznik_w] <> za_czy_przed_po[kolejny]) then
begin

wsp_z := (p_obcinania - zrodlo^[licznik_w].z) /
         (zrodlo^[kolejny].z - zrodlo^[licznik_w].z);
{x}
nowe_wierzcholki[licznik_nowych_w].x := zrodlo^[licznik_w].x +
             (zrodlo^[kolejny].x - zrodlo^[licznik_w].x) * wsp_z;
{y}
nowe_wierzcholki[licznik_nowych_w].y := zrodlo^[licznik_w].y +
             (zrodlo^[kolejny].y - zrodlo^[licznik_w].y) * wsp_z;
{z}
nowe_wierzcholki[licznik_nowych_w].z := p_obcinania;

licznik_nowych_w := licznik_nowych_w + 1;

end; {koniec bloku if rozne polozenie wierzcholkow}
end; {koniec petli for licznik_w}

{wykonujemy rzutowanie wierzcholkow trojkata na plaszczyzne rzutowania}
g_rzutuj_wierzcholki(@nowe_wierzcholki, licznik_nowych_w);

{w tym miejscu posiadamy obliczone i zrzutowane wierzcholki
 trojkata, ich liczba uzalezniona jest od polozenia trojkata
 wzgledem plaszczyzny obcinania, jezeli caly trojkat lezy przed
 plaszczyzna obcinania to posiadamy trzy wierzcholki, jezli
 jest polozony czesciowo przed i za nia to otrzymalismy
 cztery wierzcholki, kolejny etap polega na zapisaniu do
 bufora magazynujacego wszystkich par punktow stanowiacych punkt
 poczatkowy i koncowy linii tworzacych krawedzie trojkata}
if(licznik_nowych_w = 3) then
begin

for zapis := 0 to 2 do
begin
cel^ := nowe_wierzcholki[zapis];
inc(cel);
cel^ := nowe_wierzcholki[(zapis+1) mod 3];
inc(cel);
end; {koniec for zapis}

end else {jezeli licznik_nowych_w = 4}
begin

for zapis := 0 to 3 do
begin
if((nowe_wierzcholki[zapis].z = p_obcinania) and
   (nowe_wierzcholki[(zapis + 1) mod 4].z = p_obcinania)) then continue;

cel^ := nowe_wierzcholki[zapis];
inc(cel);
cel^ := nowe_wierzcholki[(zapis+1) mod 4];
inc(cel);
end; {koniec for zapis}

end;

{zwiekszamy liczbe widocznych trojkatow i przesowamy
 wskaznik zrodla na kolejny trojkat}
inc(liczba_widocznych);
inc(zrodlo);

end; {koniec petli for licznik_t}

end; {koniec procedury g_przygotuj_trokaty_do_rysowania_m_siatkowa}

{--------------}

procedure g_wyswietl_trojkaty_m_siatkowa(buf : pointer;
                                         zrodlo : wskaznik_na_w;
                                         ile : word;
                                         kolor : byte);
var
licznik : word;
wynik_a, wynik_b : wierzcholek;
zrodlo2 : wskaznik_na_w;

begin
{pomocniczy wskaznik na bufor}
zrodlo2 := zrodlo;
inc(zrodlo2);

for licznik := 0 to ile - 1 do
begin

{pierwsza krawedz trojkata}
if(g_przytnij_linie(zrodlo^, zrodlo2^, wynik_a, wynik_b) = TRUE) then
g_rysuj_linie_w_buforze(buf, round(wynik_a.x), round(wynik_a.y),
                             round(wynik_b.x), round(wynik_b.y),
                             kolor);

{druga krawedz trojkata}
inc(zrodlo, 2);
inc(zrodlo2, 2);
if(g_przytnij_linie(zrodlo^, zrodlo2^, wynik_a, wynik_b) = TRUE) then
g_rysuj_linie_w_buforze(buf, round(wynik_a.x), round(wynik_a.y),
                             round(wynik_b.x), round(wynik_b.y),
                             kolor);

{trzecia krawedz trojkata}
inc(zrodlo, 2);
inc(zrodlo2, 2);
if(g_przytnij_linie(zrodlo^, zrodlo2^, wynik_a, wynik_b) = TRUE) then
g_rysuj_linie_w_buforze(buf, round(wynik_a.x), round(wynik_a.y),
                             round(wynik_b.x), round(wynik_b.y),
                             kolor);

inc(zrodlo, 2);
inc(zrodlo2, 2);

end; {koniec petli for}

end; {koniec procedury g_wyswietl_trojkaty_m_siatkowa}

{--------------}

procedure g_rysuj_pozioma_linia_w_buforze(buf : pointer; x1, x2, y : word; kolor : byte);
begin
asm

les di, buf       {zaladuj do ES czesc segmentowa adresu zapisanego
                   w parametrze buf a czesc offsetowa umiesc w DI}
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y         {zaladuj y do AX}
mov si, ax        {zaladuj AX do SI}
shl ax, 8         {przesun bity rejestru AX o 8 pozycji w lewo}
shl si, 6         {przesun bity rejestru SI o 6 pozycji w lewo}
add di, si        {dodaj SI do DI}
add di, ax        {dodaj AX do DI}
add di, x1        {dodaj x do DI}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;

end; {koniec procedury g_rysuj_pozioma_linia_w_buforze}

{--------------}

procedure g_przygotuj_trojkaty_do_rysowania_m_wypelnione(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word);
var
licznik_t, licznik_w : word;
wektor_a, wektor_b, wektor_normalny : wierzcholek;
wynik : real;
za_czy_przed_po : array[0..2] of boolean;
licznik_z : byte;
nowe_wierzcholki : array[0..3] of wierzcholek;
licznik_nowych_w : byte;
kolejny : byte;
wsp_z : real;

begin
liczba_widocznych := 0;

for licznik_t := 0 to ile - 1 do
begin

{gromadzimy informacje o polozeniu wierzcholkow trojkata}
for licznik_z := 0  to 2 do
if(zrodlo^[licznik_z].z < p_obcinania) then
   za_czy_przed_po[licznik_z] := TRUE else
   za_czy_przed_po[licznik_z] := FALSE;

{sprawdzamy czy trojkat lezy za plaszczyzna obcinania,
jesli tak jest to przechodzimy do kolejnego trojkata}
if((za_czy_przed_po[0] = TRUE) and
   (za_czy_przed_po[1] = TRUE) and
   (za_czy_przed_po[2] = TRUE)) then
                              begin
                              inc(zrodlo);
                              continue;
                              end;

{sprawdzenie widocznosci trojkata}
if (widocznosc_t <> 3) then
begin

{obliczenie wektora normalnego trojkata}
g_odejmij_wektory(zrodlo^[0], zrodlo^[1], wektor_a);
g_odejmij_wektory(zrodlo^[2], zrodlo^[1], wektor_b);
g_oblicz_wektorowe_mnozenie_wektorow(wektor_a, wektor_b, wektor_normalny);

{oblicznie iloczynu skalarnego wektora
 normalnego trojkata i wektora kamery}
g_oblicz_iloczyn_skalarny_wektorow(wektor_normalny, zrodlo^[0], wynik);

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 1}
if(widocznosc_t = 1) then
if(wynik >= 0) then
begin
inc(zrodlo);
continue;
end;

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 2}
if(widocznosc_t = 2) then
if(wynik <= 0) then
begin
inc(zrodlo);
continue;
end;

end; {koniec bloku if (widocznosc_t <> }


licznik_nowych_w := 0;

{analiza wierzcholkow trojkata}
for licznik_w := 0 to 2 do
begin

{jezeli wierzcholek znajduje sie przed plaszczyzna obciania}
if(za_czy_przed_po[licznik_w] = FALSE) then
begin
nowe_wierzcholki[licznik_nowych_w] := zrodlo^[licznik_w];
licznik_nowych_w := licznik_nowych_w + 1;
end;

{zapisujemy do zmiennej kolejny indeks nastepnego wierzcholka}
kolejny := (licznik_w + 1) mod 3;

{jezeli polozenie wzgledem plaszczyzny obcinania aktualnie analizowanego
 wierzcholka jest rozne od polozenia nastepnego wierzcholka trojkata,
 musimy obliczyc wspolrzedne punkty w ktorym linia poprowadzona
 pomiedzy dwoma danymi wierzcholkami przetnie plaszczyzne obcinania}
if(za_czy_przed_po[licznik_w] <> za_czy_przed_po[kolejny]) then
begin

wsp_z := (p_obcinania - zrodlo^[licznik_w].z) /
         (zrodlo^[kolejny].z - zrodlo^[licznik_w].z);
{x}
nowe_wierzcholki[licznik_nowych_w].x := zrodlo^[licznik_w].x +
             (zrodlo^[kolejny].x - zrodlo^[licznik_w].x) * wsp_z;
{y}
nowe_wierzcholki[licznik_nowych_w].y := zrodlo^[licznik_w].y +
             (zrodlo^[kolejny].y - zrodlo^[licznik_w].y) * wsp_z;
{z}
nowe_wierzcholki[licznik_nowych_w].z := p_obcinania;

{kolor}
nowe_wierzcholki[licznik_nowych_w].kolor := zrodlo^[licznik_w].kolor;

licznik_nowych_w := licznik_nowych_w + 1;

end; {koniec bloku if rozne polozenie wierzcholkow}
end; {koniec petli for licznik_w}

{wykonujemy rzutowanie wierzcholkow trojkata na plaszczyzne rzutowania}
g_rzutuj_wierzcholki(@nowe_wierzcholki, licznik_nowych_w);

{w tym miejscu posiadamy obliczone i zrzutowane wierzcholki
 trojkata, ich liczba uzalezniona jest od polozenia trojkata
 wzgledem plaszczyzny obcinania, jezeli caly trojkat lezy przed
 plaszczyzna obcinania to posiadamy trzy wierzcholki, jezli
 jest polozony czesciowo przed i za nia to otrzymalismy
 cztery wierzcholki, kolejny etap polega na zapisaniu do
 bufora magazynujacego zrzutowanego trojkata, jezeli otrzymalismy
 czworokat to dzielimy go na dwa trojkaty ktore rowniez zapisujemy
 do bufora magazynujacego}
if(licznik_nowych_w = 3) then
begin

cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
inc(liczba_widocznych)

end else {jezeli licznik_nowych_w = 4}
begin

{podzielenie czworokata na dwa trojkaty}
cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
cel^[0] := nowe_wierzcholki[2];
cel^[1] := nowe_wierzcholki[3];
cel^[2] := nowe_wierzcholki[0];
inc(cel);
inc(liczba_widocznych, 2);

end;

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik_t}

end; {koniec procedury g_przygotuj_trokaty_do_rysowania_m_wypelnione}

{--------------}

procedure g_kontrola_linii_m_wypelnione(buf : pointer;
                                        x1, x2, y : longint;
                                        kolor : byte);
var
pomoc : longint;
begin

{jezeli linia ma zerowa dlugosc to wychodzimy z procedury}
if(x1 = x2) then exit;

{jezeli x1 jest wieksze od x2 to wykonujemy zamiane}
if(x1 > x2) then
begin
 pomoc := x1;
 x1 := x2;
 x2 := pomoc;
end;

{jezeli linia lezy poza ekranem to wychodzimy z procedury}
if((x1 > 319) or (x2 < 0)) then exit;

{jezeli linia wystaje poza ekran to ja przycinamy}
if(x2 > 319) then x2 := 319;
if(x1 <   0) then x1 := 0;

{narysowanie linii}
g_rysuj_pozioma_linia_w_buforze(buf, x1, x2, y, kolor);

end; {koniec procedury g_kontrola_linii_m_wypelnione}

{--------------}

procedure g_wyswietl_trojkaty_m_wypelnione(buf : pointer;
                                           zrodlo : wskaznik_na_t;
                                           ile : word;
                                           kolor : byte;
                                           ktory_kolor : boolean);
var
licznik : word;
pomoc  : wierzcholek;
wsp_a, wsp_b, wsp_c : real;
start_xa, start_xb, start_xc : real;
start_y : byte;
licznik_y : longint;
oddalenie_y : longint;
liczba_linii_faza_1, liczba_linii_faza_2 : byte;
begin

for licznik := 0 to ile - 1 do
begin


{na poczatku zaokraglamy wartosc wspolrzednych wierzcholkow, aby
 nie wykonywac tej operacji podczas kazdego dzialania}
zrodlo^[0].x := round(zrodlo^[0].x);
zrodlo^[0].y := round(zrodlo^[0].y);
zrodlo^[1].x := round(zrodlo^[1].x);
zrodlo^[1].y := round(zrodlo^[1].y);
zrodlo^[2].x := round(zrodlo^[2].x);
zrodlo^[2].y := round(zrodlo^[2].y);


{ustalamy kolor trojkata}
if(ktory_kolor = TRUE) then kolor := zrodlo^[0].kolor;

{sortujemy wierzcholki trojkata w kolejnosci
 rosnacej wartosci wspolrzednej y}
if (zrodlo^[1].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[1];
    zrodlo^[1] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[1].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[1];
    zrodlo^[1] := pomoc;
    end; {--}

{wykluczamy trojkaty ktorych na pewno nie ujzymy na ekranie}
if((zrodlo^[0].x < 0) and (zrodlo^[1].x < 0) and
   (zrodlo^[2].x < 0)) then
  begin
  inc(zrodlo);
  continue;
  end;
if((zrodlo^[0].x > 319) and (zrodlo^[1].x > 319) and
   (zrodlo^[2].x > 319)) then
  begin
  inc(zrodlo);
  continue;
  end;

if(zrodlo^[0].y > 199) then
  begin
  inc(zrodlo);
  continue;
  end;
if(zrodlo^[2].y < 0) then
  begin
  inc(zrodlo);
  continue;
  end;

{jezeli pierwszy posortowany wierzcholek lezy na ekranie
 w tej samej linii co trzeci, oznacza to brak tzw. wysokosci trojkata,
 przechodzimy wowczas do analizy nastepnego trojkata}
if(zrodlo^[0].y = zrodlo^[2].y) then
begin
inc(zrodlo);
continue;
end;

{obliczamy wspolczynnik boku b}
wsp_b := (zrodlo^[2].x - zrodlo^[0].x) /
         (zrodlo^[2].y - zrodlo^[0].y);

{pierwsza faza rysowania trojkata}
if(( zrodlo^[1].y <> zrodlo^[0].y) and
   ( zrodlo^[1].y >= 0))then
begin

  liczba_linii_faza_1 := 0;

  {obliczamy wspolczynnik boku a}
  wsp_a := (zrodlo^[1].x - zrodlo^[0].x) /
           (zrodlo^[1].y - zrodlo^[0].y);

  {okreslamy wspolrzedna x punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla pierwszej fazy rysowania}
  start_xa := zrodlo^[0].x;
  start_xb := zrodlo^[0].x;

  {przeskakujemy niewidoczny na ekranie fragment trojkata}
  if(zrodlo^[0].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[0].y);
  start_xa := start_xa + wsp_a * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  liczba_linii_faza_1 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_1 := round(zrodlo^[1].y - zrodlo^[0].y);
  start_y := round(zrodlo^[0].y);
  end;

  if (zrodlo^[1].y > 199) then liczba_linii_faza_1 := 199 - start_y;
  if((zrodlo^[1].y < 199) and (liczba_linii_faza_1 = 199)) then
     liczba_linii_faza_1 := round(zrodlo^[1].y);

  {petla rysujaca linie lezace pomiedzy
   pierwszym a drugim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_1 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

    g_kontrola_linii_m_wypelnione(buf,
                                  round(start_xa),
                                  round(start_xb),
                                  start_y,
                                  kolor);

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    start_xa := start_xa + wsp_a;
    start_xb := start_xb + wsp_b;
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku pierwsza faza rysowania}

{druga faza rysowania trojkata}
if((round(zrodlo^[1].y) <> round(zrodlo^[2].y)) and
   (zrodlo^[1].y <= 199)) then
begin

  liczba_linii_faza_2 := 0;

  {obliczamy wspolczynnik boku c}
  wsp_c := (zrodlo^[2].x - zrodlo^[1].x) /
           (zrodlo^[2].y - zrodlo^[1].y);

  {okreslamy wspolrzedna x punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla drugiej fazy rysowania}
  start_xc := zrodlo^[1].x;
  start_xb := zrodlo^[0].x + (zrodlo^[1].y - zrodlo^[0].y) * wsp_b;

  {przeskakujemy niewidoczny na ekranie fragment trojkata}
  if(zrodlo^[1].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[1].y);
  start_xc := start_xc + wsp_c * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  liczba_linii_faza_2 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_2 := round(zrodlo^[2].y - zrodlo^[1].y);
  start_y := round(zrodlo^[1].y);
  end;

  if (zrodlo^[2].y > 199) then liczba_linii_faza_2 := 199 - start_y;
  if((zrodlo^[2].y < 199) and (liczba_linii_faza_2 = 199)) then
     liczba_linii_faza_2 := round(zrodlo^[2].y);

  {petla rysujaca linie lezace pomiedzy
   drugim a trzecim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_2 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

    g_kontrola_linii_m_wypelnione(buf,
                                  round(start_xc),
                                  round(start_xb),
                                  start_y,
                                  kolor);

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    start_xc := start_xc + wsp_c;
    start_xb := start_xb + wsp_b;
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku druga faza rysowania}

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik}

end; {koniec procedury g_wyswietl_trojkaty_m_wypelnione}

{--------------}

procedure g_normalizuj_wektor(wektor : wierzcholek;
                              var wynik : wierzcholek);
var
dlugosc : real;

begin

{obliczamy dlugosc wektora}
dlugosc := sqrt((wektor.x * wektor.x) +
                (wektor.y * wektor.y) +
                (wektor.z * wektor.z));

{sprawdzamy czy dlugosc wektora nie jest zbyt mala}
if (dlugosc = 0) then dlugosc := 1;

{normalizujemy wektor}
wynik.x := wektor.x / dlugosc;
wynik.y := wektor.y / dlugosc;
wynik.z := wektor.z / dlugosc;

end; {koniec procedury g_normalizuj_wektor}

{--------------}

procedure g_przygotuj_trojkaty_do_rysowania_m_cieniowanie_p(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word;
                                        swiatlo : wierzcholek;
                                        numer_pierwszego : byte;
                                        ile_kolorow : byte);
var
licznik_t, licznik_w : word;
wektor_a, wektor_b, wektor_normalny : wierzcholek;
wynik : real;
za_czy_przed_po : array[0..2] of boolean;
licznik_z : byte;
nowe_wierzcholki : array[0..3] of wierzcholek;
licznik_nowych_w : byte;
kolejny : byte;
wsp_z : real;
znormal_wektor_normalny : wierzcholek;
znormal_wektor_swiatlo : wierzcholek;
obliczony_kolor : byte;

begin
liczba_widocznych := 0;

{wektor okreslajacy kierunek padania swiatla podczas
 dzialania procedury nie ulega zmianie, dlatego normalizujemy
 go przed petla przygotowujaca trojkaty, dzieki temu unikamy
 wielokrotnego wykonywania tego samego dzialania}
g_normalizuj_wektor(swiatlo, znormal_wektor_swiatlo);


for licznik_t := 0 to ile - 1 do
begin

{gromadzimy informacje o polozeniu wierzcholkow trojkata}
for licznik_z := 0  to 2 do
if(zrodlo^[licznik_z].z < p_obcinania) then
   za_czy_przed_po[licznik_z] := TRUE else
   za_czy_przed_po[licznik_z] := FALSE;

{sprawdzamy czy trojkat lezy za plaszczyzna obcinania,
jesli tak jest to przechodzimy do kolejnego trojkata}
if((za_czy_przed_po[0] = TRUE) and
   (za_czy_przed_po[1] = TRUE) and
   (za_czy_przed_po[2] = TRUE)) then
                              begin
                              inc(zrodlo);
                              continue;
                              end;

{sprawdzenie widocznosci trojkata}
if (widocznosc_t <> 3) then
begin

{obliczenie wektora normalnego trojkata}
g_odejmij_wektory(zrodlo^[0], zrodlo^[1], wektor_a);
g_odejmij_wektory(zrodlo^[2], zrodlo^[1], wektor_b);
g_oblicz_wektorowe_mnozenie_wektorow(wektor_a, wektor_b, wektor_normalny);

{oblicznie iloczynu skalarnego wektora
 normalnego trojkata i wektora kamery}
g_oblicz_iloczyn_skalarny_wektorow(wektor_normalny, zrodlo^[0], wynik);

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 1}
if(widocznosc_t = 1) then
if(wynik >= 0) then
begin
inc(zrodlo);
continue;
end;

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 2}
if(widocznosc_t = 2) then
if(wynik <= 0) then
begin
inc(zrodlo);
continue;
end;

end; {koniec bloku if (widocznosc_t <> }

{obliczamy odcien koloru trojkata}
{najpierw normalizujemy wektor normalny trojkata}
g_normalizuj_wektor(wektor_normalny, znormal_wektor_normalny);

{obliczmy iloczyn skalarny znormalizowanego wektora okreslajacego
 kierunek padania swiatla i wektora normalnego plaszczyzny}
g_oblicz_iloczyn_skalarny_wektorow(znormal_wektor_normalny,
                                   znormal_wektor_swiatlo, wynik);

{konieczne jezeli chcemy aby mozliwe bylo cieniowanie plaszczyzn
 odwruconych tylem do kamery}
if(widocznosc_t = 2) then wynik := -wynik;

{sprawdzamy otrzymany wynik i podejmujemy odpowiednie dzialania}
if(wynik >= 0) then
begin
zrodlo^[0].kolor := numer_pierwszego;
zrodlo^[1].kolor := numer_pierwszego;
zrodlo^[2].kolor := numer_pierwszego;
end else
begin
wynik := -wynik;
obliczony_kolor := round((wynik * (ile_kolorow-1)) + numer_pierwszego);
zrodlo^[0].kolor := obliczony_kolor;
zrodlo^[1].kolor := obliczony_kolor;
zrodlo^[2].kolor := obliczony_kolor;
end; {koniec bloku if(wynik >= 0)}

licznik_nowych_w := 0;

{analiza wierzcholkow trojkata}
for licznik_w := 0 to 2 do
begin

{jezeli wierzcholek znajduje sie przed plaszczyzna obciania}
if(za_czy_przed_po[licznik_w] = FALSE) then
begin
nowe_wierzcholki[licznik_nowych_w] := zrodlo^[licznik_w];
licznik_nowych_w := licznik_nowych_w + 1;
end;

{zapisujemy do zmiennej kolejny indeks nastepnego wierzcholka}
kolejny := (licznik_w + 1) mod 3;

{jezeli polozenie wzgledem plaszczyzny obcinania aktualnie analizowanego
 wierzcholka jest rozne od polozenia nastepnego wierzcholka trojkata,
 musimy obliczyc wspolrzedne punkty w ktorym linia poprowadzona
 pomiedzy dwoma danymi wierzcholkami przetnie plaszczyzne obcinania}
if(za_czy_przed_po[licznik_w] <> za_czy_przed_po[kolejny]) then
begin

wsp_z := (p_obcinania - zrodlo^[licznik_w].z) /
         (zrodlo^[kolejny].z - zrodlo^[licznik_w].z);
{x}
nowe_wierzcholki[licznik_nowych_w].x := zrodlo^[licznik_w].x +
             (zrodlo^[kolejny].x - zrodlo^[licznik_w].x) * wsp_z;
{y}
nowe_wierzcholki[licznik_nowych_w].y := zrodlo^[licznik_w].y +
             (zrodlo^[kolejny].y - zrodlo^[licznik_w].y) * wsp_z;
{z}
nowe_wierzcholki[licznik_nowych_w].z := p_obcinania;

{kolor}
nowe_wierzcholki[licznik_nowych_w].kolor := zrodlo^[licznik_w].kolor;

licznik_nowych_w := licznik_nowych_w + 1;

end; {koniec bloku if rozne polozenie wierzcholkow}
end; {koniec petli for licznik_w}

{wykonujemy rzutowanie wierzcholkow trojkata na plaszczyzne rzutowania}
g_rzutuj_wierzcholki(@nowe_wierzcholki, licznik_nowych_w);

{w tym miejscu posiadamy obliczone i zrzutowane wierzcholki
 trojkata, ich liczba uzalezniona jest od polozenia trojkata
 wzgledem plaszczyzny obcinania, jezeli caly trojkat lezy przed
 plaszczyzna obcinania to posiadamy trzy wierzcholki, jezli
 jest polozony czesciowo przed i za nia to otrzymalismy
 cztery wierzcholki, kolejny etap polega na zapisaniu do
 bufora magazynujacego zrzutowanego trojkata, jezeli otrzymalismy
 czworokat to dzielimy go na dwa trojkaty ktore rowniez zapisujemy
 do bufora magazynujacego}
if(licznik_nowych_w = 3) then
begin

cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
inc(liczba_widocznych)

end else {jezeli licznik_nowych_w = 4}
begin

{podzielenie czworokata na dwa trojkaty}
cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
cel^[0] := nowe_wierzcholki[2];
cel^[1] := nowe_wierzcholki[3];
cel^[2] := nowe_wierzcholki[0];
inc(cel);
inc(liczba_widocznych, 2);

end;

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik_t}

end; {koniec procedury g_przygotuj_trokaty_do_rysowania_m_cieniowanie_p}

{--------------}

procedure g_przygotuj_trojkaty_do_rysowania_m_tekstura(
                                        zrodlo : wskaznik_na_t;
                                        cel : wskaznik_na_t;
                                        ile : word;
                                        var liczba_widocznych  : word);
var
licznik_t, licznik_w : word;
wektor_a, wektor_b, wektor_normalny : wierzcholek;
wynik : real;
za_czy_przed_po : array[0..2] of boolean;
licznik_z : byte;
nowe_wierzcholki : array[0..3] of wierzcholek;
licznik_nowych_w : byte;
kolejny : byte;
wsp_z : real;

begin
liczba_widocznych := 0;

for licznik_t := 0 to ile - 1 do
begin

{gromadzimy informacje o polozeniu wierzcholkow trojkata}
for licznik_z := 0  to 2 do
if(zrodlo^[licznik_z].z < p_obcinania) then
   za_czy_przed_po[licznik_z] := TRUE else
   za_czy_przed_po[licznik_z] := FALSE;

{sprawdzamy czy trojkat lezy za plaszczyzna obcinania,
jesli tak jest to przechodzimy do kolejnego trojkata}
if((za_czy_przed_po[0] = TRUE) and
   (za_czy_przed_po[1] = TRUE) and
   (za_czy_przed_po[2] = TRUE)) then
                              begin
                              inc(zrodlo);
                              continue;
                              end;

{sprawdzenie widocznosci trojkata}
if (widocznosc_t <> 3) then
begin

{obliczenie wektora normalnego trojkata}
g_odejmij_wektory(zrodlo^[0], zrodlo^[1], wektor_a);
g_odejmij_wektory(zrodlo^[2], zrodlo^[1], wektor_b);
g_oblicz_wektorowe_mnozenie_wektorow(wektor_a, wektor_b, wektor_normalny);{!}

{oblicznie iloczynu skalarnego wektora
 normalnego trojkata i wektora kamery}
g_oblicz_iloczyn_skalarny_wektorow(wektor_normalny, zrodlo^[0], wynik);

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 1}
if(widocznosc_t = 1) then
if(wynik >= 0) then
begin
inc(zrodlo);
continue;
end;

{sprawdzenie widocznosci trojkata dla ustawiania widocznosc_t = 2}
if(widocznosc_t = 2) then
if(wynik <= 0) then
begin
inc(zrodlo);
continue;
end;

end; {koniec bloku if (widocznosc_t <> }


licznik_nowych_w := 0;

{analiza wierzcholkow trojkata}
for licznik_w := 0 to 2 do
begin

{jezeli wierzcholek znajduje sie przed plaszczyzna obciania}
if(za_czy_przed_po[licznik_w] = FALSE) then
begin
nowe_wierzcholki[licznik_nowych_w] := zrodlo^[licznik_w];
licznik_nowych_w := licznik_nowych_w + 1;
end;

{zapisujemy do zmiennej kolejny indeks nastepnego wierzcholka}
kolejny := (licznik_w + 1) mod 3;

{jezeli polozenie wzgledem plaszczyzny obcinania aktualnie analizowanego
 wierzcholka jest rozne od polozenia nastepnego wierzcholka trojkata,
 musimy obliczyc wspolrzedne punkty w ktorym linia poprowadzona
 pomiedzy dwoma danymi wierzcholkami przetnie plaszczyzne obcinania}
if(za_czy_przed_po[licznik_w] <> za_czy_przed_po[kolejny]) then
begin

wsp_z := (p_obcinania - zrodlo^[licznik_w].z) /
         (zrodlo^[kolejny].z - zrodlo^[licznik_w].z);
{x}
nowe_wierzcholki[licznik_nowych_w].x := zrodlo^[licznik_w].x +
             (zrodlo^[kolejny].x - zrodlo^[licznik_w].x) * wsp_z;
{y}
nowe_wierzcholki[licznik_nowych_w].y := zrodlo^[licznik_w].y +
             (zrodlo^[kolejny].y - zrodlo^[licznik_w].y) * wsp_z;
{z}
nowe_wierzcholki[licznik_nowych_w].z := p_obcinania;

{kolor}
nowe_wierzcholki[licznik_nowych_w].kolor := zrodlo^[licznik_w].kolor;

{u}
nowe_wierzcholki[licznik_nowych_w].u := round(zrodlo^[licznik_w].u +
              (zrodlo^[kolejny].u - zrodlo^[licznik_w].u) * wsp_z);

{v}
nowe_wierzcholki[licznik_nowych_w].v := round(zrodlo^[licznik_w].v +
              (zrodlo^[kolejny].v - zrodlo^[licznik_w].v) * wsp_z);

licznik_nowych_w := licznik_nowych_w + 1;

end; {koniec bloku if rozne polozenie wierzcholkow}
end; {koniec petli for licznik_w}

{wykonujemy rzutowanie wierzcholkow trojkata na plaszczyzne rzutowania}
g_rzutuj_wierzcholki(@nowe_wierzcholki, licznik_nowych_w);

{w tym miejscu posiadamy obliczone i zrzutowane wierzcholki
 trojkata, ich liczba uzalezniona jest od polozenia trojkata
 wzgledem plaszczyzny obcinania, jezeli caly trojkat lezy przed
 plaszczyzna obcinania to posiadamy trzy wierzcholki, jezli
 jest polozony czesciowo przed i za nia to otrzymalismy
 cztery wierzcholki, kolejny etap polega na zapisaniu do
 bufora magazynujacego zrzutowanego trojkata, jezeli otrzymalismy
 czworokat to dzielimy go na dwa trojkaty ktore rowniez zapisujemy
 do bufora magazynujacego}
if(licznik_nowych_w = 3) then
begin

cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
inc(liczba_widocznych)

end else {jezeli licznik_nowych_w = 4}
begin

{podzielenie czworokata na dwa trojkaty}
cel^[0] := nowe_wierzcholki[0];
cel^[1] := nowe_wierzcholki[1];
cel^[2] := nowe_wierzcholki[2];
inc(cel);
cel^[0] := nowe_wierzcholki[2];
cel^[1] := nowe_wierzcholki[3];
cel^[2] := nowe_wierzcholki[0];
inc(cel);
inc(liczba_widocznych, 2);

end;

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik_t}

end; {koniec procedury g_przygotuj_trokaty_do_rysowania_m_tekstura}

{--------------}

procedure g_kontrola_linii_m_tekstura(buf : pointer;
                                      x1, x2, y : longint;
                                      u1, v1, u2, v2 : byte;
                                      tekstura : obraz;
                                      ile_przesunac : byte);
var
pomoc : longint;
pomoc_b : byte;
delta_u, delta_v, _u, _v : single;
licznik : word;
obliczony_y : word;
begin

obliczony_y := (y shl 8) + (y shl 6); {y*320}

{jezeli linia ma zerowa dlugosc to wychodzimy z procedury}
if(x1 = x2) then exit;

{jezeli x1 jest wieksze od x2 to wykonujemy zamiane}
if(x1 > x2) then
begin
 pomoc := x1;
 x1 := x2;
 x2 := pomoc;
 pomoc_b := u1;
 u1 := u2;
 u2 := pomoc_b;
 pomoc_b := v1;
 v1 := v2;
 v2 := pomoc_b;
end;

{jezeli linia lezy poza ekranem to wychodzimy z procedury}
if((x1 > 319) or (x2 < 0)) then exit;

{obliczamy liniowy przyrost wspolrzednej u i v}
delta_u := (u2 - u1) / (x2 - x1);
delta_v := (v2 - v1) / (x2 - x1);

{jezeli linia wystaje poza ekran to ja przycinamy}
if(x2 > 319) then x2 := 319;
if(x1 <   0) then
begin
u1 := u1 + round((delta_u * (-x1)));
v1 := v1 + round((delta_v * (-x1)));
x1 := 0;
end;

_u := u1;
_v := v1;

{narysowanie linii}
for licznik := x1 to x2 do
begin

{rysujemy piksel}
asm

les di, tekstura.wsk_obrazu   {laduj adres tekstury do rejestrow ES, DI}
add di, word ptr u1           {dodaj u1 do DI}
mov si, word ptr v1           {laduj v1 do SI}
mov cl, ile_przesunac         {laduj ile_przesunac do CL}
shl si, cl                    {pomnuz SI przez dlugosc boku tekstury}
add di, si                    {dodaj SI do DI}
mov ah, byte ptr es:[di]      {laduj do AH piksel tekstury}
les di, buf                   {laduj adres bufora wideo rejestrow ES, DI}
add di, licznik               {dodaj licznik do DI}
add di, obliczony_y           {dodaj obliczony_y do DI}
mov byte ptr es:[di], ah      {zapisz wartosc rejestru AH do komorki spod
                               adresu ES:DI, czyli umiesc piksel tekstury
                               w buforze wideo}
end; {koniec bloku asm rysujacego piksel}

{okreslamy wspolrzedna kolejnego piksela tekstury}
asm
fld _u         {laduj _u na szczyt stosu koprocesora ST(0) = _u}
fld delta_u    {laduj delta_u na szczyt stosu koprocesora ST(0) = delta_u,
                ST(1) = _u}
fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
fstp _u        {laduj wartosc z ST(0) do _u}
{}
fld _v         {laduj _v na szczyt stosu koprocesora ST(0) = _v}
fld delta_v    {laduj delta_v na szczyt stosu koprocesora ST(0) = delta_v,
                ST(1) = _v}
fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
fstp _v        {laduj wartosc z ST(0) do _v}
end;

{powyzszy kod asemblerowy wykonuje to samo zadanie co ponizsze instrukcje}
{
_u := _u + delta_u;
_v := _v + delta_v;
}

{przeksztalcamy wartosci zmiennoprzecinkowe na calkowite}
u1 := round(_u);
v1 := round(_v);

end; {koniec petli for licznik}

end; {koniec procedury g_kontrola_linii_m_tekstura}

{--------------}

procedure g_wyswietl_trojkaty_m_tekstura(buf : pointer;
                                         zrodlo : wskaznik_na_t;
                                         ile : word;
                                         tekstura : obraz);
var
licznik : word;
pomoc  : wierzcholek;
wsp_a, wsp_b, wsp_c : single;
start_xa, start_xb, start_xc : single;
start_y : byte;
licznik_y : longint;
oddalenie_y : longint;
liczba_linii_faza_1, liczba_linii_faza_2 : byte;
start_ua, start_va, start_ub, start_vb, start_uc, start_vc : single;
wsp_au, wsp_av, wsp_bu, wsp_bv, wsp_cu, wsp_cv : single;
licznik_b, ile_przesunac, tester : byte;
begin

{sprawdzamy o ile bitow nalezy przesunac dana liczbe w lewo aby otrzymac
 rownowazny efekt z pomnozeniem jej przez szerokosc tekstury,
 zakladamy ze tekstura ma rozmiar rowny pewnej potegi liczby 2 }
tester := 1;
for licznik_b := 0 to 7 do
if((tester and tekstura.szerokosc) <> 0) then
begin
ile_przesunac := licznik_b;
break;    {przerwij petle}
end else
    tester := tester shl 1;


{petla rysujaca trojkaty}
for licznik := 0 to ile - 1 do
begin


{na poczatku zaokraglamy wartosc wspolrzednych wierzcholkow, aby
 nie wykonywac tej operacji podczas kazdego dzialania}
zrodlo^[0].x := round(zrodlo^[0].x);
zrodlo^[0].y := round(zrodlo^[0].y);
zrodlo^[1].x := round(zrodlo^[1].x);
zrodlo^[1].y := round(zrodlo^[1].y);
zrodlo^[2].x := round(zrodlo^[2].x);
zrodlo^[2].y := round(zrodlo^[2].y);



{sortujemy wierzcholki trojkata w kolejnosci
 rosnacej wartosci wspolrzednej y}
if (zrodlo^[1].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[1];
    zrodlo^[1] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[1].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[1];
    zrodlo^[1] := pomoc;
    end; {--}

{wykluczamy trojkaty ktorych na pewno nie ujzymy na ekranie}
if((zrodlo^[0].x < 0) and (zrodlo^[1].x < 0) and
   (zrodlo^[2].x < 0)) then
  begin
  inc(zrodlo);
  continue;
  end;
if((zrodlo^[0].x > 319) and (zrodlo^[1].x > 319) and
   (zrodlo^[2].x > 319)) then
  begin
  inc(zrodlo);
  continue;
  end;

if(zrodlo^[0].y > 199) then
  begin
  inc(zrodlo);
  continue;
  end;
if(zrodlo^[2].y < 0) then
  begin
  inc(zrodlo);
  continue;
  end;

{jezeli pierwszy posortowany wierzcholek lezy na ekranie
 w tej samej linii co trzeci, oznacza to brak tzw. wysokosci trojkata,
 przechodzimy wowczas do analizy nastepnego trojkata}
if(zrodlo^[0].y = zrodlo^[2].y) then
begin
inc(zrodlo);
continue;
end;

{obliczamy wspolczynniki dla boku b}
wsp_b := (zrodlo^[2].x - zrodlo^[0].x) /
         (zrodlo^[2].y - zrodlo^[0].y);
wsp_bu := (zrodlo^[2].u - zrodlo^[0].u) /
          (zrodlo^[2].y - zrodlo^[0].y);
wsp_bv := (zrodlo^[2].v - zrodlo^[0].v) /
          (zrodlo^[2].y - zrodlo^[0].y);

{pierwsza faza rysowania trojkata}
if(( zrodlo^[1].y <> zrodlo^[0].y) and
   ( zrodlo^[1].y >= 0))then
begin

  liczba_linii_faza_1 := 0;

  {obliczamy wspolczynniki dla boku a}
  wsp_a := (zrodlo^[1].x - zrodlo^[0].x) /
           (zrodlo^[1].y - zrodlo^[0].y);
  wsp_au := (zrodlo^[1].u - zrodlo^[0].u) /
            (zrodlo^[1].y - zrodlo^[0].y);
  wsp_av := (zrodlo^[1].v - zrodlo^[0].v) /
            (zrodlo^[1].y - zrodlo^[0].y);

  {okreslamy wspolrzedna x, u i v punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla pierwszej fazy rysowania}
  start_xa := zrodlo^[0].x;
  start_xb := zrodlo^[0].x;
  start_ua := zrodlo^[0].u;
  start_va := zrodlo^[0].v;
  start_ub := zrodlo^[0].u;
  start_vb := zrodlo^[0].v;

  {przeskakujemy niewidoczny na ekranie fragment trojkata}
  if(zrodlo^[0].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[0].y);
  start_xa := start_xa + wsp_a * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  start_ua := start_ua + round(wsp_au * oddalenie_y);
  start_va := start_va + round(wsp_av * oddalenie_y);
  start_ub := start_ub + round(wsp_bu * oddalenie_y);
  start_vb := start_vb + round(wsp_bv * oddalenie_y);
  liczba_linii_faza_1 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_1 := round(zrodlo^[1].y - zrodlo^[0].y);
  start_y := round(zrodlo^[0].y);
  end;

  if (zrodlo^[1].y > 199) then liczba_linii_faza_1 := 199 - start_y;
  if((zrodlo^[1].y < 199) and (liczba_linii_faza_1 = 199)) then
     liczba_linii_faza_1 := round(zrodlo^[1].y);

  {petla rysujaca linie lezace pomiedzy
   pierwszym a drugim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_1 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

       g_kontrola_linii_m_tekstura(buf,
                                round(start_xa),
                                round(start_xb),
                                start_y,
                                round(start_ua), round(start_va),
                                round(start_ub), round(start_vb),
                                tekstura,
                                ile_przesunac);

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    asm
    {}
    fld start_xa   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xa}
    fld wsp_a      {laduj wsp_a na szczyt stosu koprocesora ST(0) = wsp_a,
                    ST(1) = start_xa}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xa  {laduj wartosc z ST(0) do start_xa}
    {}
    fld start_xb   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xb}
    fld wsp_b      {laduj wsp_b na szczyt stosu koprocesora ST(0) = wsp_b,
                    ST(1) = start_xb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xb  {laduj wartosc z ST(0) do start_xb}
    {}
    fld start_ua   {laduj start_ua na szczyt stosu koprocesora
                    ST(0) = start_ua}
    fld wsp_au     {laduj wsp_au na szczyt stosu koprocesora ST(0) = wsp_au,
                    ST(1) = start_ua}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ua  {laduj wartosc z ST(0) do start_ua}
    {}
    fld start_va   {laduj start_va na szczyt stosu koprocesora
                    ST(0) = start_va}
    fld wsp_av     {laduj wsp_av na szczyt stosu koprocesora ST(0) = wsp_av,
                    ST(1) = start_va}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_va  {laduj wartosc z ST(0) do start_va}
    {}
    fld start_ub   {laduj start_ub na szczyt stosu koprocesora
                    ST(0) = start_ub}
    fld wsp_bu     {laduj wsp_bu na szczyt stosu koprocesora ST(0) = wsp_bu,
                    ST(1) = start_ub}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ub  {laduj wartosc z ST(0) do start_ub}
    {}
    fld start_vb   {laduj start_vb na szczyt stosu koprocesora
                    ST(0) = start_vb}
    fld wsp_bv     {laduj wsp_bv na szczyt stosu koprocesora ST(0) = wsp_bv,
                    ST(1) = start_vb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vb  {laduj wartosc z ST(0) do start_vb}
    end;
{powyzszy kod asemblerowy zastepuje szesc nastepujacych operacji dodawania}
{   start_xa := start_xa + wsp_a;
    start_xb := start_xb + wsp_b;
    start_ua := start_ua + wsp_au;
    start_va := start_va + wsp_av;
    start_ub := start_ub + wsp_bu;
    start_vb := start_vb + wsp_bv;
    }
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku pierwsza faza rysowania}

{druga faza rysowania trojkata}
if((round(zrodlo^[1].y) <> round(zrodlo^[2].y)) and
   (zrodlo^[1].y <= 199)) then
begin

  liczba_linii_faza_2 := 0;

  {obliczamy wspolczynniki dla boku c}
  wsp_c := (zrodlo^[2].x - zrodlo^[1].x) /
           (zrodlo^[2].y - zrodlo^[1].y);
  wsp_cu := (zrodlo^[2].u - zrodlo^[1].u) /
            (zrodlo^[2].y - zrodlo^[1].y);
  wsp_cv := (zrodlo^[2].v - zrodlo^[1].v) /
            (zrodlo^[2].y - zrodlo^[1].y);

  {okreslamy wspolrzedna x, u i v punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla drugiej fazy rysowania}
  start_xc := zrodlo^[1].x;
  start_xb := zrodlo^[0].x + (zrodlo^[1].y - zrodlo^[0].y) * wsp_b;
  start_uc := zrodlo^[1].u;
  start_vc := zrodlo^[1].v;
  start_ub := round(zrodlo^[0].u + (zrodlo^[1].y - zrodlo^[0].y) * wsp_bu);
  start_vb := round(zrodlo^[0].v + (zrodlo^[1].y - zrodlo^[0].y) * wsp_bv);

  {przeskakujemy niewidoczny na ekranie fragment trojkata}
  if(zrodlo^[1].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[1].y);
  start_xc := start_xc + wsp_c * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  start_uc := start_uc + round(wsp_cu * oddalenie_y);
  start_vc := start_vc + round(wsp_cv * oddalenie_y);
  start_ub := start_ub + round(wsp_bu * oddalenie_y);
  start_vb := start_vb + round(wsp_bv * oddalenie_y);
  liczba_linii_faza_2 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_2 := round(zrodlo^[2].y - zrodlo^[1].y);
  start_y := round(zrodlo^[1].y);
  end;

  if (zrodlo^[2].y > 199) then liczba_linii_faza_2 := 199 - start_y;
  if((zrodlo^[2].y < 199) and (liczba_linii_faza_2 = 199)) then
     liczba_linii_faza_2 := round(zrodlo^[2].y);

  {petla rysujaca linie lezace pomiedzy
   drugim a trzecim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_2 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

    g_kontrola_linii_m_tekstura(buf,
                                round(start_xc),
                                round(start_xb),
                                start_y,
                                round(start_uc), round(start_vc),
                                round(start_ub), round(start_vb),
                                tekstura,
                                ile_przesunac);

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    asm
    {}
    fld start_xc   {laduj start_xc na szczyt stosu koprocesora
                    ST(0) = start_xc}
    fld wsp_c      {laduj wsp_c na szczyt stosu koprocesora ST(0) = wsp_c,
                    ST(1) = start_xc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xc  {laduj wartosc z ST(0) do start_xc}
    {}
    fld start_xb   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xb}
    fld wsp_b      {laduj wsp_b na szczyt stosu koprocesora ST(0) = wsp_b,
                    ST(1) = start_xb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xb  {laduj wartosc z ST(0) do start_xb}
    {}
    fld start_uc   {laduj start_uc na szczyt stosu koprocesora
                    ST(0) = start_uc}
    fld wsp_cu     {laduj wsp_cu na szczyt stosu koprocesora ST(0) = wsp_cu,
                    ST(1) = start_uc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_uc  {laduj wartosc z ST(0) do start_uc}
    {}
    fld start_vc   {laduj start_vc na szczyt stosu koprocesora
                    ST(0) = start_vc}
    fld wsp_cv     {laduj wsp_cv na szczyt stosu koprocesora ST(0) = wsp_cv,
                    ST(1) = start_vc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vc  {laduj wartosc z ST(0) do start_vc}
    {}
    fld start_ub   {laduj start_ub na szczyt stosu koprocesora
                    ST(0) = start_ub}
    fld wsp_bu     {laduj wsp_bu na szczyt stosu koprocesora ST(0) = wsp_bu,
                    ST(1) = start_ub}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ub  {laduj wartosc z ST(0) do start_ub}
    {}
    fld start_vb   {laduj start_vb na szczyt stosu koprocesora
                    ST(0) = start_vb}
    fld wsp_bv     {laduj wsp_bv na szczyt stosu koprocesora ST(0) = wsp_bv,
                    ST(1) = start_vb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vb  {laduj wartosc z ST(0) do start_vb}
    end;
{powyzszy kod asemblerowy zastepuje szesc nastepujacych operacji dodawania}
{   start_xc := start_xc + wsp_c;
    start_xb := start_xb + wsp_b;
    start_uc := start_uc + wsp_cu;
    start_vc := start_vc + wsp_cv;
    start_ub := start_ub + wsp_bu;
    start_vb := start_vb + wsp_bv;
    }
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku druga faza rysowania}

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik}

end; {koniec procedury g_wyswietl_trojkaty_m_tekstura}

{--------------}

procedure g_kontrola_linii_m_tekstura_kp(buf : pointer;
                                      x1, x2, y : longint;
                                      u1, v1, u2, v2 : single;
                                      tekstura : obraz;
                                      ile_przesunac : byte;
                                      z1, z2 : single
                                      );
var
pomoc : longint;
pomoc_s : single;
delta_u, delta_v : single;
licznik : word;
obliczony_y : word;
wsp_z, delta_z, jeden : single;
_v1, _u1 : word;
begin

jeden := 1.0;

obliczony_y := (y shl 8) + (y shl 6); {y*320}

{jezeli linia ma zerowa dlugosc to wychodzimy z procedury}
if(x1 = x2) then exit;

{jezeli x1 jest wieksze od x2 to wykonujemy zamiane}
if(x1 > x2) then
begin
 pomoc := x1;
 x1 := x2;
 x2 := pomoc;
 pomoc_s := u1;
 u1 := u2;
 u2 := pomoc_s;
 pomoc_s := v1;
 v1 := v2;
 v2 := pomoc_s;
 pomoc_s := z1;
 z1 := z2;
 z2 := pomoc_s;
end;

{jezeli linia lezy poza ekranem to wychodzimy z procedury}
if((x1 > 319) or (x2 < 0)) then exit;

{obliczamy liniowy przyrost wspolrzednej u, v i z}
delta_u := (u2 - u1) / (x2 - x1);
delta_v := (v2 - v1) / (x2 - x1);
delta_z := (z2 - z1) / (x2 - x1);

{jezeli linia wystaje poza ekran to ja przycinamy}
if(x2 > 319) then x2 := 319;
if(x1 <   0) then
begin
u1 := u1 + delta_u * (-x1);
v1 := v1 + delta_v * (-x1);
z1 := z1 + delta_z * (-x1);
x1 := 0;
end;

{narysowanie linii}
for licznik := x1 to x2 do
begin

{obliczenie wspolczynnika Z i wspolrzednych u, v tekstury}
asm
fld jeden     {laduj jeden na szczyt stosu koprocesora ST(0) = jeden}
fld z1        {laduj z1 na szczyt stosu koprocesora ST(0) = z1,
               ST(1) = jeden}
fdiv          {podziel ST(0) przez ST(1), wynik umiesc w ST(0)}
fstp wsp_z    {laduj wartosc z ST(0) do wsp_z}
{}
fld u1         {laduj u1 na szczyt stosu koprocesora ST(0) = u1}
fld wsp_z      {laduj wsp_z na szczyt stosu koprocesora ST(0) = wsp_z,
                ST(1) = u1}
fmul           {pomnoz ST(0) przez ST(1), wynik umiesc w ST(0)}
fistp _u1      {laduj wartosc z ST(0) do _u1}
{}
fld v1         {laduj v1 na szczyt stosu koprocesora ST(0) = v1}
fld wsp_z      {laduj wsp_z na szczyt stosu koprocesora ST(0) = wsp_z,
                ST(1) = v1}
fmul           {pomnoz ST(0) przez ST(1), wynik umiesc w ST(0)}
fistp _v1      {laduj wartosc z ST(0) do _v1}
end;

{powyzszy kod asemblerowy wykonuje to samo zadanie co ponizsze trzy linie kodu
  wsp_z := 1.0 / z1;
 _u1 := round(u1 * wsp_z);
 _v1 := round(v1 * wsp_z);
}

{rysujemy piksel}
asm

les di, tekstura.wsk_obrazu   {laduj adres tekstury do rejestrow ES, DI}
add di, _u1                   {dodaj u1 do DI}
mov si, _v1                   {laduj v1 do SI}
mov cl, ile_przesunac         {laduj ile_przesunac do CL}
shl si, cl                    {pomnuz SI przez dlugosc boku tekstury}
add di, si                    {dodaj SI do DI}
mov ah, byte ptr es:[di]      {laduj do AH piksel tekstury}
les di, buf                   {laduj adres bufora wideo rejestrow ES, DI}
add di, licznik               {dodaj licznik do DI}
add di, obliczony_y           {dodaj obliczony_y do DI}
mov byte ptr es:[di], ah      {zapisz wartosc rejestru AH do komorki spod
                               adresu ES:DI, czyli umiesc piksel tekstury
                               w buforze wideo}
end; {koniec bloku asm rysujacego piksel}


{okreslamy wspolrzedna kolejnego piksela tekstury}
asm
fld u1         {laduj u1 na szczyt stosu koprocesora ST(0) = u1}
fld delta_u    {laduj delta_u na szczyt stosu koprocesora ST(0) = delta_u,
                ST(1) = u1}
fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
fstp u1        {laduj wartosc z ST(0) do u1}
{}
fld v1         {laduj v1 na szczyt stosu koprocesora ST(0) = v1}
fld delta_v    {laduj delta_v na szczyt stosu koprocesora ST(0) = delta_v,
                ST(1) = v1}
fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
fstp v1        {laduj wartosc z ST(0) do v1}
{}
fld z1         {laduj z1 na szczyt stosu koprocesora ST(0) = z1}
fld delta_z    {laduj delta_v na szczyt stosu koprocesora ST(0) = delta_v,
                ST(1) = z1}
fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
fstp z1        {laduj wartosc z ST(0) do z1}
end;

{powyzszy kod asemblerowy wykonuje to samo zadanie co ponizsze instrukcje}
{
u1 := u1 + delta_u;
v1 := v1 + delta_v;
z1 := z1 + delta_z;
}

end; {koniec petli for licznik}

end; {koniec procedury g_kontrola_linii_m_tekstura_kp}

{--------------}

procedure g_wyswietl_trojkaty_m_tekstura_kp(buf : pointer;
                                         zrodlo : wskaznik_na_t;
                                         ile : word;
                                         tekstura : obraz
                                         );
var
licznik : word;
pomoc  : wierzcholek;
wsp_a, wsp_b, wsp_c : single;
start_xa, start_xb, start_xc : single;
start_y : byte;
licznik_y : longint;
oddalenie_y : longint;
liczba_linii_faza_1, liczba_linii_faza_2 : byte;
start_ua, start_va, start_ub, start_vb, start_uc, start_vc : single;
wsp_au, wsp_av, wsp_bu, wsp_bv, wsp_cu, wsp_cv : single;
wsp_az, wsp_bz, wsp_cz, start_za, start_zb, start_zc : single;
licznik_b, ile_przesunac, tester : byte;
begin

{sprawdzamy o ile bitow nalezy przesunac dana liczbe w lewo aby otrzymac
 rownowazny efekt z pomnozeniem jej przez szerokosc tekstury,
 zakladamy ze tekstura ma rozmiar rowny pewnej potegi liczby 2 }
tester := 1;
for licznik_b := 0 to 7 do
if((tester and tekstura.szerokosc) <> 0) then
begin
ile_przesunac := licznik_b;
break;    {przerwij petle}
end else
    tester := tester shl 1;


{petla rysujaca trojkaty}
for licznik := 0 to ile - 1 do
begin


{na poczatku zaokraglamy wartosc wspolrzednych wierzcholkow, aby
 nie wykonywac tej operacji podczas kazdego dzialania}
zrodlo^[0].x := round(zrodlo^[0].x);
zrodlo^[0].y := round(zrodlo^[0].y);
zrodlo^[1].x := round(zrodlo^[1].x);
zrodlo^[1].y := round(zrodlo^[1].y);
zrodlo^[2].x := round(zrodlo^[2].x);
zrodlo^[2].y := round(zrodlo^[2].y);



{sortujemy wierzcholki trojkata w kolejnosci
 rosnacej wartosci wspolrzednej y}
if (zrodlo^[1].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[1];
    zrodlo^[1] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[2].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[2];
    zrodlo^[2] := pomoc;
    end; {--}
if (zrodlo^[0].y > zrodlo^[1].y) then
    begin
    pomoc := zrodlo^[0];
    zrodlo^[0] := zrodlo^[1];
    zrodlo^[1] := pomoc;
    end; {--}

{wykluczamy trojkaty ktorych na pewno nie ujzymy na ekranie}
if((zrodlo^[0].x < 0) and (zrodlo^[1].x < 0) and
   (zrodlo^[2].x < 0)) then
  begin
  inc(zrodlo);
  continue;
  end;
if((zrodlo^[0].x > 319) and (zrodlo^[1].x > 319) and
   (zrodlo^[2].x > 319)) then
  begin
  inc(zrodlo);
  continue;
  end;

if(zrodlo^[0].y > 199) then
  begin
  inc(zrodlo);
  continue;
  end;
if(zrodlo^[2].y < 0) then
  begin
  inc(zrodlo);
  continue;
  end;

{jezeli pierwszy posortowany wierzcholek lezy na ekranie
 w tej samej linii co trzeci, oznacza to brak tzw. wysokosci trojkata,
 przechodzimy wowczas do analizy nastepnego trojkata}
if(zrodlo^[0].y = zrodlo^[2].y) then
begin
inc(zrodlo);
continue;
end;

{obliczamy wspolczynniki dla boku b}
wsp_b := (zrodlo^[2].x - zrodlo^[0].x) /
         (zrodlo^[2].y - zrodlo^[0].y);

wsp_bu := (zrodlo^[2].u / zrodlo^[2].z - zrodlo^[0].u / zrodlo^[0].z) /  (zrodlo^[2].y - zrodlo^[0].y);

wsp_bv := (zrodlo^[2].v / zrodlo^[2].z - zrodlo^[0].v / zrodlo^[0].z) / (zrodlo^[2].y - zrodlo^[0].y);

wsp_bz := (1 / zrodlo^[2].z - 1 / zrodlo^[0].z) / (zrodlo^[2].y - zrodlo^[0].y);

{pierwsza faza rysowania trojkata}
if(( zrodlo^[1].y <> zrodlo^[0].y) and
   ( zrodlo^[1].y >= 0))then
begin

  liczba_linii_faza_1 := 0;

  {obliczamy wspolczynniki dla boku a}
  wsp_a := (zrodlo^[1].x - zrodlo^[0].x) /
           (zrodlo^[1].y - zrodlo^[0].y);

  wsp_au := (zrodlo^[1].u / zrodlo^[1].z - zrodlo^[0].u / zrodlo^[0].z) / (zrodlo^[1].y - zrodlo^[0].y);

  wsp_av := (zrodlo^[1].v / zrodlo^[1].z - zrodlo^[0].v / zrodlo^[0].z) / (zrodlo^[1].y - zrodlo^[0].y);

  wsp_az := (1 / zrodlo^[1].z - 1 / zrodlo^[0].z) / (zrodlo^[1].y - zrodlo^[0].y);


  {okreslamy wspolrzedna x, u i v punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla pierwszej fazy rysowania}
  start_xa := zrodlo^[0].x;
  start_xb := zrodlo^[0].x;
  start_ua := zrodlo^[0].u / zrodlo^[0].z;
  start_va := zrodlo^[0].v / zrodlo^[0].z;
  start_ub := zrodlo^[0].u / zrodlo^[0].z;
  start_vb := zrodlo^[0].v / zrodlo^[0].z;
  start_za := 1.0 / zrodlo^[0].z;
  start_zb := 1.0 / zrodlo^[0].z;

  {przeskakujemy niewidoczny na ekranie fragment trojkata}
  if(zrodlo^[0].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[0].y);
  start_xa := start_xa + wsp_a * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  start_ua := start_ua + wsp_au * oddalenie_y;
  start_va := start_va + wsp_av * oddalenie_y;
  start_ub := start_ub + wsp_bu * oddalenie_y;
  start_vb := start_vb + wsp_bv * oddalenie_y;
  start_za := start_za + wsp_az * oddalenie_y;
  start_zb := start_zb + wsp_bz * oddalenie_y;

  liczba_linii_faza_1 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_1 := round(zrodlo^[1].y - zrodlo^[0].y);
  start_y := round(zrodlo^[0].y);
  end;

  if (zrodlo^[1].y > 199) then liczba_linii_faza_1 := 199 - start_y;
  if((zrodlo^[1].y < 199) and (liczba_linii_faza_1 = 199)) then
     liczba_linii_faza_1 := round(zrodlo^[1].y);

  {petla rysujaca linie lezace pomiedzy
   pierwszym a drugim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_1 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

       g_kontrola_linii_m_tekstura_kp(buf,
                                round(start_xa),
                                round(start_xb),
                                start_y,
                                start_ua, start_va,
                                start_ub, start_vb,
                                tekstura,
                                ile_przesunac,
                                start_za, start_zb
                                );

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    asm
    {}
    fld start_xa   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xa}
    fld wsp_a      {laduj wsp_a na szczyt stosu koprocesora ST(0) = wsp_a,
                    ST(1) = start_xa}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xa  {laduj wartosc z ST(0) do start_xa}
    {}
    fld start_xb   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xb}
    fld wsp_b      {laduj wsp_b na szczyt stosu koprocesora ST(0) = wsp_b,
                    ST(1) = start_xb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xb  {laduj wartosc z ST(0) do start_xb}
    {}
    fld start_ua   {laduj start_ua na szczyt stosu koprocesora
                    ST(0) = start_ua}
    fld wsp_au     {laduj wsp_au na szczyt stosu koprocesora ST(0) = wsp_au,
                    ST(1) = start_ua}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ua  {laduj wartosc z ST(0) do start_ua}
    {}
    fld start_va   {laduj start_va na szczyt stosu koprocesora
                    ST(0) = start_va}
    fld wsp_av     {laduj wsp_av na szczyt stosu koprocesora ST(0) = wsp_av,
                    ST(1) = start_va}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_va  {laduj wartosc z ST(0) do start_va}
    {}
    fld start_ub   {laduj start_ub na szczyt stosu koprocesora
                    ST(0) = start_ub}
    fld wsp_bu     {laduj wsp_bu na szczyt stosu koprocesora ST(0) = wsp_bu,
                    ST(1) = start_ub}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ub  {laduj wartosc z ST(0) do start_ub}
    {}
    fld start_vb   {laduj start_vb na szczyt stosu koprocesora
                    ST(0) = start_vb}
    fld wsp_bv     {laduj wsp_bv na szczyt stosu koprocesora ST(0) = wsp_bv,
                    ST(1) = start_vb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vb  {laduj wartosc z ST(0) do start_vb}
    {}
    fld start_za   {laduj start_za na szczyt stosu koprocesora
                    ST(0) = start_za}
    fld wsp_az     {laduj wsp_az na szczyt stosu koprocesora ST(0) = wsp_az,
                    ST(1) = start_za}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_za  {laduj wartosc z ST(0) do start_za}
    {}
    fld start_zb   {laduj start_zb na szczyt stosu koprocesora
                    ST(0) = start_zb}
    fld wsp_bz     {laduj wsp_bz na szczyt stosu koprocesora ST(0) = wsp_bz,
                    ST(1) = start_zb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_zb  {laduj wartosc z ST(0) do start_zb}
    end;
{powyzszy kod asemblerowy zastepuje szesc nastepujacych operacji dodawania}
{   start_xa := start_xa + wsp_a;
    start_xb := start_xb + wsp_b;
    start_ua := start_ua + wsp_au;
    start_va := start_va + wsp_av;
    start_ub := start_ub + wsp_bu;
    start_vb := start_vb + wsp_bv;
    start_za := start_za + wsp_az;
    start_zb := start_zb + wsp_bz;
    }
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku pierwsza faza rysowania}

{inc(zrodlo);
continue;
{druga faza rysowania trojkata}
if((round(zrodlo^[1].y) <> round(zrodlo^[2].y)) and
   (zrodlo^[1].y <= 199)) then
begin

  liczba_linii_faza_2 := 0;

  {obliczamy wspolczynniki dla boku c}
  wsp_c := (zrodlo^[2].x - zrodlo^[1].x) / (zrodlo^[2].y - zrodlo^[1].y);

  wsp_cu := (zrodlo^[2].u  / zrodlo^[2].z - zrodlo^[1].u / zrodlo^[1].z) /  (zrodlo^[2].y - zrodlo^[1].y);

  wsp_cv := (zrodlo^[2].v / zrodlo^[2].z - zrodlo^[1].v / zrodlo^[1].z ) / (zrodlo^[2].y - zrodlo^[1].y);

  wsp_cz := (1 / zrodlo^[2].z - 1 / zrodlo^[1].z) / (zrodlo^[2].y - zrodlo^[1].y);

  {okreslamy wspolrzedna x, u i v punktu poczatkowego i koncowego pierwszej
  linii trojkata, dla drugiej fazy rysowania}
  start_xc := zrodlo^[1].x;
  start_xb := zrodlo^[0].x + (zrodlo^[1].y - zrodlo^[0].y) * wsp_b;
  start_uc := zrodlo^[1].u / zrodlo^[1].z;
  start_vc := zrodlo^[1].v / zrodlo^[1].z;
  start_ub := (zrodlo^[0].u / zrodlo^[0].z) + (zrodlo^[1].y - zrodlo^[0].y) * wsp_bu;
  start_vb := (zrodlo^[0].v / zrodlo^[0].z) + (zrodlo^[1].y - zrodlo^[0].y) * wsp_bv;
  start_zc := 1 / zrodlo^[1].z;
  start_zb := (1 / zrodlo^[0].z) + (zrodlo^[1].y - zrodlo^[0].y) * wsp_bz;

  {przeskakujemy niewidoczny na ekranie fragment trojkata, odpowiednio
   zwiekszamy rowniez wszystkie wspolczynniki}
  if(zrodlo^[1].y < 0) then
  begin
  oddalenie_y := -round(zrodlo^[1].y);
  start_xc := start_xc + wsp_c * oddalenie_y;
  start_xb := start_xb + wsp_b * oddalenie_y;
  start_uc := start_uc + wsp_cu * oddalenie_y;
  start_vc := start_vc + wsp_cv * oddalenie_y;
  start_ub := start_ub + wsp_bu * oddalenie_y;
  start_vb := start_vb + wsp_bv * oddalenie_y;
  start_zc := start_zc + wsp_cz * oddalenie_y;
  start_zb := start_zb + wsp_bz * oddalenie_y;
  liczba_linii_faza_2 := 199;
  start_y := 0;
  end else
  begin
  liczba_linii_faza_2 := round(zrodlo^[2].y - zrodlo^[1].y);
  start_y := round(zrodlo^[1].y);
  end;

  if (zrodlo^[2].y > 199) then liczba_linii_faza_2 := 199 - start_y;
  if((zrodlo^[2].y < 199) and (liczba_linii_faza_2 = 199)) then
     liczba_linii_faza_2 := round(zrodlo^[2].y);

  {petla rysujaca linie lezace pomiedzy
   drugim a trzecim wierzcholkiem trojkata}
  for licznik_y := 0 to liczba_linii_faza_2 do
  begin

    {linie rysujemy tylko wtedy gdy jest widoczna na ekranie}
    if((start_y >= 0) and (start_y <= 199)) then
    begin

    g_kontrola_linii_m_tekstura_kp(buf,
                                round(start_xc),
                                round(start_xb),
                                start_y,
                                start_uc, start_vc,
                                start_ub, start_vb,
                                tekstura,
                                ile_przesunac,
                                start_zc, start_zb
                                );

    end; {koniec bloku if licznik_y >= 0}

    {okreslamy wspolrzedna x punktu poczatkowego i koncowego kolejnej
     rysowanej poziomej linii trojkata}
    asm
    {}
    fld start_xc   {laduj start_xc na szczyt stosu koprocesora
                    ST(0) = start_xc}
    fld wsp_c      {laduj wsp_c na szczyt stosu koprocesora ST(0) = wsp_c,
                    ST(1) = start_xc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xc  {laduj wartosc z ST(0) do start_xc}
    {}
    fld start_xb   {laduj start_xa na szczyt stosu koprocesora
                    ST(0) = start_xb}
    fld wsp_b      {laduj wsp_b na szczyt stosu koprocesora ST(0) = wsp_b,
                    ST(1) = start_xb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_xb  {laduj wartosc z ST(0) do start_xb}
    {}
    fld start_uc   {laduj start_uc na szczyt stosu koprocesora
                    ST(0) = start_uc}
    fld wsp_cu     {laduj wsp_cu na szczyt stosu koprocesora ST(0) = wsp_cu,
                    ST(1) = start_uc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_uc  {laduj wartosc z ST(0) do start_uc}
    {}
    fld start_vc   {laduj start_vc na szczyt stosu koprocesora
                    ST(0) = start_vc}
    fld wsp_cv     {laduj wsp_cv na szczyt stosu koprocesora ST(0) = wsp_cv,
                    ST(1) = start_vc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vc  {laduj wartosc z ST(0) do start_vc}
    {}
    fld start_ub   {laduj start_ub na szczyt stosu koprocesora
                    ST(0) = start_ub}
    fld wsp_bu     {laduj wsp_bu na szczyt stosu koprocesora ST(0) = wsp_bu,
                    ST(1) = start_ub}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_ub  {laduj wartosc z ST(0) do start_ub}
    {}
    fld start_vb   {laduj start_vb na szczyt stosu koprocesora
                    ST(0) = start_vb}
    fld wsp_bv     {laduj wsp_bv na szczyt stosu koprocesora ST(0) = wsp_bv,
                    ST(1) = start_vb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_vb  {laduj wartosc z ST(0) do start_vb}
    {}
    fld start_zb   {laduj start_zb na szczyt stosu koprocesora
                    ST(0) = start_zb}
    fld wsp_bz     {laduj wsp_bz na szczyt stosu koprocesora ST(0) = wsp_bz,
                    ST(1) = start_zb}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_zb  {laduj wartosc z ST(0) do start_zb}
    {}
    fld start_zc   {laduj start_zc na szczyt stosu koprocesora
                    ST(0) = start_zc}
    fld wsp_cz     {laduj wsp_cz na szczyt stosu koprocesora ST(0) = wsp_cz,
                    ST(1) = start_zc}
    fadd           {dodaj ST(0) do ST(1), wynik umiesc w ST(0)}
    fstp start_zc  {laduj wartosc z ST(0) do start_zc}
    end;
{powyzszy kod asemblerowy zastepuje szesc nastepujacych operacji dodawania}
{   start_xc := start_xc + wsp_c;
    start_xb := start_xb + wsp_b;
    start_uc := start_uc + wsp_cu;
    start_vc := start_vc + wsp_cv;
    start_ub := start_ub + wsp_bu;
    start_vb := start_vb + wsp_bv;
    start_zb := start_zb + wsp_bz;
    start_zc := start_zc + wsp_cz;
    }
    start_y  := start_y + 1;

  end; {koniec petli for licznik_y}

end; {koniec bloku druga faza rysowania}

{przesowamy wskaznik zrodla na kolejny trojkat}
inc(zrodlo);

end; {koniec petli for licznik}

end; {koniec procedury g_wyswietl_trojkaty_m_tekstura_kp}

end. {koniec modulu}

